/*
 * Copyright (c) 2022  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Multi-access Traffic Steering Sercice REST API
 *
 * Multi-access Traffic Steering Sercice is AdvantEDGE's implementation of [ETSI MEC ISG MEC015 Traffic Management APIs](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/015/02.02.01_60/gs_MEC015v020201p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-tm](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-tm/server/mts) <p>***Type & Usage**<br>Edge Service used by edge applications that want to get information about MTS Info and Session(s) in the network <p>**Note**<br>AdvantEDGE supports all Multi-access Traffic Steering API endpoints.
 *
 * API version: 2.2.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

type MtsSessionInfoFlowFilter struct {
	// DSCP in the IPv4 header or Traffic Class in the IPv6 header
	Dscp int32 `json:"dscp,omitempty"`
	// Destination address identity of session (including range)
	DstIp string `json:"dstIp,omitempty"`
	// Destination port identity of session
	DstPort []int32 `json:"dstPort,omitempty"`
	// Flow Label in the IPv6 header, applicable only if the flow is IPv6
	Flowlabel int32 `json:"flowlabel,omitempty"`
	// Protocol number
	Protocol int32 `json:"protocol,omitempty"`
	// Source address identity of session (including range)
	SourceIp string `json:"sourceIp,omitempty"`
	// Source port identity of session
	SourcePort []int32 `json:"sourcePort,omitempty"`
}
