# Go API client for swagger

Bandwidth Management Sercice is AdvantEDGE's implementation of [ETSI MEC ISG MEC015 Traffic Management APIs](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/015/02.02.01_60/gs_MEC015v020201p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-tm](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-tm/server/bwm) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about BWM Info and Session(s) in the network <p>**Note**<br>AdvantEDGE supports all Bandwidth Management API endpoints.

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 2.2.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/bwm/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BwmApi* | [**BandwidthAllocationDELETE**](docs/BwmApi.md#bandwidthallocationdelete) | **Delete** /bw_allocations/{allocationId} | Remove a specific bandwidthAllocation
*BwmApi* | [**BandwidthAllocationGET**](docs/BwmApi.md#bandwidthallocationget) | **Get** /bw_allocations/{allocationId} | Retrieve information about a specific bandwidthAllocation
*BwmApi* | [**BandwidthAllocationListGET**](docs/BwmApi.md#bandwidthallocationlistget) | **Get** /bw_allocations | Retrieve information about a list of bandwidthAllocation resources
*BwmApi* | [**BandwidthAllocationPATCH**](docs/BwmApi.md#bandwidthallocationpatch) | **Patch** /bw_allocations/{allocationId} | Modify the information about a specific existing bandwidthAllocation by sending updates on the data structure
*BwmApi* | [**BandwidthAllocationPOST**](docs/BwmApi.md#bandwidthallocationpost) | **Post** /bw_allocations | Create a bandwidthAllocation resource
*BwmApi* | [**BandwidthAllocationPUT**](docs/BwmApi.md#bandwidthallocationput) | **Put** /bw_allocations/{allocationId} | Update the information about a specific bandwidthAllocation
*LocationApi* | [**Mec011AppTerminationPOST**](docs/LocationApi.md#mec011appterminationpost) | **Post** /notifications/mec011/appTermination | MEC011 Application Termination notification for self termination

## Documentation For Models

 - [AppTerminationNotification](docs/AppTerminationNotification.md)
 - [AppTerminationNotificationLinks](docs/AppTerminationNotificationLinks.md)
 - [BwInfo](docs/BwInfo.md)
 - [BwInfoDeltas](docs/BwInfoDeltas.md)
 - [BwInfoDeltasSessionFilter](docs/BwInfoDeltasSessionFilter.md)
 - [BwInfoSessionFilter](docs/BwInfoSessionFilter.md)
 - [BwInfoTimeStamp](docs/BwInfoTimeStamp.md)
 - [LinkType](docs/LinkType.md)
 - [OperationActionType](docs/OperationActionType.md)
 - [ProblemDetails](docs/ProblemDetails.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com
