# Go API client for client

ETSI GS MEC 021 Application Mobility Service API described using OpenAPI.

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 2.2.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen
For more information, please visit [https://forge.etsi.org/rep/mec/gs021-amsi-api](https://forge.etsi.org/rep/mec/gs021-amsi-api)

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/amsi/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AppMobSerApi* | [**AppMobilityServiceByIdDELETE**](docs/AppMobSerApi.md#appmobilityservicebyiddelete) | **Delete** /app_mobility_services/{appMobilityServiceId} |  deregister the individual application mobility service
*AppMobSerApi* | [**AppMobilityServiceByIdGET**](docs/AppMobSerApi.md#appmobilityservicebyidget) | **Get** /app_mobility_services/{appMobilityServiceId} | Retrieve information about this individual application mobility service
*AppMobSerApi* | [**AppMobilityServiceByIdPUT**](docs/AppMobSerApi.md#appmobilityservicebyidput) | **Put** /app_mobility_services/{appMobilityServiceId} |  update the existing individual application mobility service
*AppMobSerApi* | [**AppMobilityServiceGET**](docs/AppMobSerApi.md#appmobilityserviceget) | **Get** /app_mobility_services | Retrieve information about the registered application mobility service.
*AppMobSerApi* | [**AppMobilityServicePOST**](docs/AppMobSerApi.md#appmobilityservicepost) | **Post** /app_mobility_services | Create a new application mobility service for the service requester.
*LocationApi* | [**Mec011AppTerminationPOST**](docs/LocationApi.md#mec011appterminationpost) | **Post** /notifications/mec011/appTermination | MEC011 Application Termination notification for self termination
*NotificationsApi* | [**NotificationPOST**](docs/NotificationsApi.md#notificationpost) | **Post** /uri_provided_by_subscriber | delivers a notification from the AMS resource to the subscriber
*SubscriptionsApi* | [**SubByIdDELETE**](docs/SubscriptionsApi.md#subbyiddelete) | **Delete** /subscriptions/{subscriptionId} | cancel the existing individual subscription
*SubscriptionsApi* | [**SubByIdGET**](docs/SubscriptionsApi.md#subbyidget) | **Get** /subscriptions/{subscriptionId} | Retrieve information about this subscription.
*SubscriptionsApi* | [**SubByIdPUT**](docs/SubscriptionsApi.md#subbyidput) | **Put** /subscriptions/{subscriptionId} | update the existing individual subscription.
*SubscriptionsApi* | [**SubGET**](docs/SubscriptionsApi.md#subget) | **Get** /subscriptions | Retrieve information about the subscriptions for this requestor.
*SubscriptionsApi* | [**SubPOST**](docs/SubscriptionsApi.md#subpost) | **Post** /subscriptions | Create a new subscription to Application Mobility Service notifications.
*UnsupportedApi* | [**AdjAppInstGET**](docs/UnsupportedApi.md#adjappinstget) | **Get** /queries/adjacent_app_instances | Retrieve information about this subscription.
*UnsupportedApi* | [**AppMobilityServiceDerPOST**](docs/UnsupportedApi.md#appmobilityservicederpost) | **Post** /app_mobility_services/{appMobilityServiceId}/deregister_task |  deregister the individual application mobility service


## Documentation For Models

 - [AdjacentAppInfoNotification](docs/AdjacentAppInfoNotification.md)
 - [AdjacentAppInfoNotificationAdjacentAppInfo](docs/AdjacentAppInfoNotificationAdjacentAppInfo.md)
 - [AdjacentAppInfoSubscription](docs/AdjacentAppInfoSubscription.md)
 - [AdjacentAppInfoSubscriptionFilterCriteria](docs/AdjacentAppInfoSubscriptionFilterCriteria.md)
 - [AdjacentAppInfoSubscriptionLinks](docs/AdjacentAppInfoSubscriptionLinks.md)
 - [AdjacentAppInstanceInfo](docs/AdjacentAppInstanceInfo.md)
 - [AppMobilityServiceLevel](docs/AppMobilityServiceLevel.md)
 - [AppTerminationNotification](docs/AppTerminationNotification.md)
 - [AppTerminationNotificationLinks](docs/AppTerminationNotificationLinks.md)
 - [AssociateId](docs/AssociateId.md)
 - [Body](docs/Body.md)
 - [Body1](docs/Body1.md)
 - [Body2](docs/Body2.md)
 - [CommunicationInterface](docs/CommunicationInterface.md)
 - [CommunicationInterfaceIpAddresses](docs/CommunicationInterfaceIpAddresses.md)
 - [ContextTransferState](docs/ContextTransferState.md)
 - [ExpiryNotification](docs/ExpiryNotification.md)
 - [LinkType](docs/LinkType.md)
 - [MecHostInformation](docs/MecHostInformation.md)
 - [MobilityProcedureNotification](docs/MobilityProcedureNotification.md)
 - [MobilityProcedureNotificationLinks](docs/MobilityProcedureNotificationLinks.md)
 - [MobilityProcedureNotificationTargetAppInfo](docs/MobilityProcedureNotificationTargetAppInfo.md)
 - [MobilityProcedureSubscription](docs/MobilityProcedureSubscription.md)
 - [MobilityProcedureSubscriptionFilterCriteria](docs/MobilityProcedureSubscriptionFilterCriteria.md)
 - [MobilityProcedureSubscriptionLinks](docs/MobilityProcedureSubscriptionLinks.md)
 - [MobilityStatus](docs/MobilityStatus.md)
 - [ModelType](docs/ModelType.md)
 - [OneOfbody](docs/OneOfbody.md)
 - [OneOfbody1](docs/OneOfbody1.md)
 - [OneOfbody2](docs/OneOfbody2.md)
 - [OperationActionType](docs/OperationActionType.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [RegistrationInfo](docs/RegistrationInfo.md)
 - [RegistrationInfoDeviceInformation](docs/RegistrationInfoDeviceInformation.md)
 - [RegistrationInfoServiceConsumerId](docs/RegistrationInfoServiceConsumerId.md)
 - [SubscriptionLinkList](docs/SubscriptionLinkList.md)
 - [SubscriptionLinkListLinks](docs/SubscriptionLinkListLinks.md)
 - [SubscriptionLinkListSubscription](docs/SubscriptionLinkListSubscription.md)
 - [SubscriptionType](docs/SubscriptionType.md)
 - [TestNotification](docs/TestNotification.md)
 - [TestNotificationLinks](docs/TestNotificationLinks.md)
 - [TimeStamp](docs/TimeStamp.md)
 - [WebsockNotifConfig](docs/WebsockNotifConfig.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

cti_support@etsi.org
