/*
 * ETSI GS MEC 016 Device application interface
 *
 * The ETSI MEC ISG Device application interface API described using OpenAPI.
 *
 * API version: 2.2.1
 * Generated by: Swagger Codegen (https://github.com/server-api/server-codegen.git)
 */
package server

import (
	"fmt"
	"net/http"
	"strings"

	httpLog "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-http-logger"
	met "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-metrics"

	"github.com/gorilla/mux"
)

type Route struct {
	Name        string
	Method      string
	Pattern     string
	HandlerFunc http.HandlerFunc
}

type Routes []Route

func NewRouter() *mux.Router {
	router := mux.NewRouter().StrictSlash(true)
	var handler http.Handler
	for _, route := range routes {
		handler = route.HandlerFunc
		handler = Logger(handler, route.Name)
		handler = met.MetricsHandler(handler, sandboxName, serviceName)
		handler = httpLog.LogRx(handler, "")
		router.
			Methods(route.Method).
			Path(route.Pattern).
			Name(route.Name).
			Handler(handler)
	}

	// Path prefix router order is important
	// Service Api files
	handler = http.StripPrefix("/dev_app/v1/api/", http.FileServer(http.Dir("./api/")))
	router.
		PathPrefix("/dev_app/v1/api/").
		Name("Api").
		Handler(handler)
	// User supplied service API files
	handler = http.StripPrefix("/dev_app/v1/user-api/", http.FileServer(http.Dir("./user-api/")))
	router.
		PathPrefix("/dev_app/v1/user-api/").
		Name("UserApi").
		Handler(handler)

	return router
}

func Index(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello World!")
}

var routes = Routes{
	Route{
		"Index",
		"GET",
		"/dev_app/v1/",
		Index,
	},

	Route{
		"Mec011AppTerminationPOST",
		strings.ToUpper("Post"),
		"/dev_app/v1/notifications/mec011/appTermination",
		Mec011AppTerminationPOST,
	},

	Route{
		"AppLocationAvailabilityPOST",
		strings.ToUpper("Post"),
		"/dev_app/v1/obtain_app_loc_availability",
		AppLocationAvailabilityPOST,
	},

	Route{
		"DevAppContextDELETE",
		strings.ToUpper("Delete"),
		"/dev_app/v1/app_contexts/{contextId}",
		DevAppContextDELETE,
	},

	Route{
		"DevAppContextPUT",
		strings.ToUpper("Put"),
		"/dev_app/v1/app_contexts/{contextId}",
		DevAppContextPUT,
	},

	Route{
		"DevAppContextsPOST",
		strings.ToUpper("Post"),
		"/dev_app/v1/app_contexts",
		DevAppContextsPOST,
	},

	Route{
		"MeAppListGET",
		strings.ToUpper("Get"),
		"/dev_app/v1/app_list",
		MeAppListGET,
	},

	Route{
		"IndividualSubscriptionDELETE",
		strings.ToUpper("Delete"),
		"/dev_app/v1/subscriptions/{subscriptionId}",
		IndividualSubscriptionDELETE,
	},
}
