/*
 * MEC On-boarded Demo 4 API
 *
 * Demo 4 is an device application that can be instanciated over the UE Application interface
 *
 * API version: 0.0.1
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package server

import (
	"net/http"
	"strings"
)

// A FrontendApiController binds http requests to an api service and writes the service results to the http response
type FrontendApiController struct {
	service FrontendApiServicer
}

// NewFrontendApiController creates a default api controller
func NewFrontendApiController(s FrontendApiServicer) Router {
	return &FrontendApiController{service: s}
}

// Routes returns all of the api route for the FrontendApiController
func (c *FrontendApiController) Routes() Routes {
	return Routes{
		{
			"Ping",
			strings.ToUpper("Get"),
			"/ping",
			c.Ping,
		},
		{
			"Terminate",
			strings.ToUpper("Delete"),
			"/",
			c.Terminate,
		},
	}
}

// Ping - Await for ping request and reply winth pong text body
func (c *FrontendApiController) Ping(w http.ResponseWriter, r *http.Request) {
	result, err := c.service.Ping(r.Context())
	if err != nil {
		w.WriteHeader(500)
		return
	}

	EncodeJSONResponse(result, nil, w)
}

// Terminate - Terminate gracefully the application
func (c *FrontendApiController) Terminate(w http.ResponseWriter, r *http.Request) {
	result, err := c.service.Terminate(r.Context())
	if err != nil {
		w.WriteHeader(500)
		return
	}

	EncodeJSONResponse(result, nil, w)
}
