/*
 * MEC On-boarded Demo 4 API
 *
 * Demo 4 is an device application that can be instanciated over the UE Application interface
 *
 * API version: 0.0.1
 * Generated by: OpenAPI Generator (https://server-generator.tech)
 */

package main

import (
	"context"
	"log"
	"net/http"
	"os"
	"os/signal"

	server "github.com/InterDigitalInc/AdvantEDGE/example/demo4/src/onboarded-demo/server"
)

const (
	port = ":31124" // hardcoded in mepp-dai Chart template
)

func main() {
	err := server.Init()
	if err != nil {
		log.Fatal("Failed to initalize onboarded-demo4 ", err)
	}

	// Channel sync pass channel listen for app termination
	server.Run()

	FrontendApiService := server.NewFrontendApiService()
	FrontendApiController := server.NewFrontendApiController(FrontendApiService)

	router := server.NewRouter(FrontendApiController)

	log.Printf("Server started on port " + port)
	srv := &http.Server{Addr: port, Handler: router}
	go func() {
		//returns ErrServerClosed on graceful close
		log.Printf("Call ListenAndServe")
		if err := srv.ListenAndServe(); err != http.ErrServerClosed {
			log.Printf("ListenAndServe(): %s", err)
			return
		}
		log.Printf("Terminate goroutine")
	}()

	//	log.Fatal(http.ListenAndServe(port, router))
	log.Printf("Configure signals")
	c := make(chan os.Signal)
	signal.Notify(c, os.Interrupt)
	sig := <-c
	log.Printf("Got %s signal. Aborting...\n", sig)
	server.Terminate()
	err = srv.Shutdown(context.TODO())
	if err != nil {
		log.Printf("Shutdown(): %s", err)
		return
	}
}
