/*
 * MEC Demo 4 API
 *
 * Demo 4 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC011 and MEC021 usage
 *
 * API version: 0.0.1
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package server

type ApplicationLocationAvailabilityAppInfo struct {

	// Identifies the version of the application descriptor. It is equivalent to the appDVersion defined in clause 6.2.1.2 of ETSI GS MEC 0102 [1].
	AppDVersion string `json:"appDVersion"`

	// Human readable description of the MEC application. The length of the value shall not exceed 128 characters.
	AppDescription string `json:"appDescription,omitempty"`

	// Name of the MEC application. The length of the value shall not exceed 32 characters.
	AppName string `json:"appName"`

	// URI of the application package. Shall be included in the request. The application package shall comply with the definitions in clause 6.2.1.2 of ETSI GS MEC 0102 [1].
	AppPackageSource string `json:"appPackageSource,omitempty"`

	// Provider of the MEC application. The length of the value shall not exceed 32 characters.
	AppProvider string `json:"appProvider"`

	// Software version of the MEC application. The length of the value shall not exceed 32 characters.
	AppSoftVersion string `json:"appSoftVersion,omitempty"`

	// MEC application location constraints.
	AvailableLocations []ApplicationLocationAvailabilityAppInfoAvailableLocations `json:"availableLocations,omitempty"`
}
