/*
 * MEC Demo 4 API
 *
 * Demo 4 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC011 and MEC021 usage
 *
 * API version: 0.0.1
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package server

type ApplicationListAppInfo struct {
	AppCharcs ApplicationListAppInfoAppCharcs `json:"appCharcs,omitempty"`

	// Identifier of this MEC application descriptor. It is equivalent to the appDId defined in clause 6.2.1.2 of ETSI GS MEC 0102 [1]. This attribute shall be globally unique.
	AppDId string `json:"appDId"`

	// Identifies the version of the application descriptor. It is equivalent to the appDVersion defined in clause 6.2.1.2 of ETSI GS MEC 0102 [1].
	AppDVersion string `json:"appDVersion"`

	// Human readable description of the MEC application (see note 2).
	AppDescription string `json:"appDescription"`

	// Identifies the locations of the MEC application.
	AppLocation []LocationConstraints `json:"appLocation,omitempty"`

	// Name of the MEC application. The length of the value shall not exceed 32 characters.
	AppName string `json:"appName"`

	// Provider of the MEC application. The length of the value shall not exceed 32 characters.
	AppProvider string `json:"appProvider"`

	// Software version of the MEC application. The length of the value shall not exceed 32 characters.
	AppSoftVersion string `json:"appSoftVersion"`
}
