# Documentation for AdvantEDGE Multi-access Traffic Steering API

<a name="documentation-for-api-endpoints"></a>
## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/mts/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MtsApi* | [**mec011AppTerminationPOST**](Apis/MtsApi.md#mec011appterminationpost) | **POST** /notifications/mec011/appTermination | MEC011 Application Termination notification for self termination
*MtsApi* | [**mtsCapabilityInfoGET**](Apis/MtsApi.md#mtscapabilityinfoget) | **GET** /mts_capability_info | Retrieve the MTS capability informations
*MtsApi* | [**mtsSessionDELETE**](Apis/MtsApi.md#mtssessiondelete) | **DELETE** /mts_sessions/{sessionId} | Remove specific MTS session
*MtsApi* | [**mtsSessionGET**](Apis/MtsApi.md#mtssessionget) | **GET** /mts_sessions/{sessionId} | Retrieve information about specific MTS session
*MtsApi* | [**mtsSessionPOST**](Apis/MtsApi.md#mtssessionpost) | **POST** /mts_sessions | Create a MTS session
*MtsApi* | [**mtsSessionPUT**](Apis/MtsApi.md#mtssessionput) | **PUT** /mts_sessions/{sessionId} | Update the information about specific MTS session
*MtsApi* | [**mtsSessionsListGET**](Apis/MtsApi.md#mtssessionslistget) | **GET** /mts_sessions | Retrieve information about a list of MTS sessions


<a name="documentation-for-models"></a>
## Documentation for Models

 - [AppTerminationNotification](./Models/AppTerminationNotification.md)
 - [AppTerminationNotificationLinks](./Models/AppTerminationNotificationLinks.md)
 - [LinkType](./Models/LinkType.md)
 - [MtsCapabilityInfo](./Models/MtsCapabilityInfo.md)
 - [MtsCapabilityInfoMtsAccessInfo](./Models/MtsCapabilityInfoMtsAccessInfo.md)
 - [MtsCapabilityInfoTimeStamp](./Models/MtsCapabilityInfoTimeStamp.md)
 - [MtsSessionInfo](./Models/MtsSessionInfo.md)
 - [MtsSessionInfoFlowFilter](./Models/MtsSessionInfoFlowFilter.md)
 - [MtsSessionInfoQosD](./Models/MtsSessionInfoQosD.md)
 - [MtsSessionInfoTimeStamp](./Models/MtsSessionInfoTimeStamp.md)
 - [OperationActionType](./Models/OperationActionType.md)
 - [ProblemDetails](./Models/ProblemDetails.md)


<a name="documentation-for-authorization"></a>
## Documentation for Authorization

All endpoints do not require authorization.
