# MtsApi

All URIs are relative to *https://localhost/sandboxname/mts/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**mec011AppTerminationPOST**](MtsApi.md#mec011AppTerminationPOST) | **POST** /notifications/mec011/appTermination | MEC011 Application Termination notification for self termination
[**mtsCapabilityInfoGET**](MtsApi.md#mtsCapabilityInfoGET) | **GET** /mts_capability_info | Retrieve the MTS capability informations
[**mtsSessionDELETE**](MtsApi.md#mtsSessionDELETE) | **DELETE** /mts_sessions/{sessionId} | Remove specific MTS session
[**mtsSessionGET**](MtsApi.md#mtsSessionGET) | **GET** /mts_sessions/{sessionId} | Retrieve information about specific MTS session
[**mtsSessionPOST**](MtsApi.md#mtsSessionPOST) | **POST** /mts_sessions | Create a MTS session
[**mtsSessionPUT**](MtsApi.md#mtsSessionPUT) | **PUT** /mts_sessions/{sessionId} | Update the information about specific MTS session
[**mtsSessionsListGET**](MtsApi.md#mtsSessionsListGET) | **GET** /mts_sessions | Retrieve information about a list of MTS sessions


<a name="mec011AppTerminationPOST"></a>
# **mec011AppTerminationPOST**
> mec011AppTerminationPOST(AppTerminationNotification)

MEC011 Application Termination notification for self termination

    Terminates itself.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **AppTerminationNotification** | [**AppTerminationNotification**](../Models/AppTerminationNotification.md)| Termination notification details |

### Return type

null (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined

<a name="mtsCapabilityInfoGET"></a>
# **mtsCapabilityInfoGET**
> MtsCapabilityInfo mtsCapabilityInfoGET()

Retrieve the MTS capability informations

    Used to query information about the MTS information. Typically used in the &#39;Get MTS service Info from the MTS Service&#39; procedure as described in clause 6.2.6.

### Parameters
This endpoint does not need any parameter.

### Return type

[**MtsCapabilityInfo**](../Models/MtsCapabilityInfo.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json, application/problem+json

<a name="mtsSessionDELETE"></a>
# **mtsSessionDELETE**
> mtsSessionDELETE(sessionId)

Remove specific MTS session

    DELETE method is typically used in &#39;Unregister from the MTS Service&#39; procedure as described in clause 6.2.8.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionId** | **String**| Represents a MTS session instance | [default to null]

### Return type

null (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/problem+json

<a name="mtsSessionGET"></a>
# **mtsSessionGET**
> MtsSessionInfo mtsSessionGET(sessionId)

Retrieve information about specific MTS session

    Retrieves information about an individual MTS session. Typically used in the &#39;Get configured MTS Session Info from the MTS Service&#39; procedure as described in clause 6.2.10.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionId** | **String**| Represents a MTS session instance | [default to null]

### Return type

[**MtsSessionInfo**](../Models/MtsSessionInfo.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json, application/problem+json

<a name="mtsSessionPOST"></a>
# **mtsSessionPOST**
> MtsSessionInfo mtsSessionPOST(MtsSessionInfo)

Create a MTS session

    Used to create a MTS session. This method is typically used in &#39;Register application to the MTS Service&#39; procedure as described in clause 6.2.7.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **MtsSessionInfo** | [**MtsSessionInfo**](../Models/MtsSessionInfo.md)| Entity body in the request contains MtsSessionInfo to be created. |

### Return type

[**MtsSessionInfo**](../Models/MtsSessionInfo.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json, application/problem+json

<a name="mtsSessionPUT"></a>
# **mtsSessionPUT**
> MtsSessionInfo mtsSessionPUT(sessionId, MtsSessionInfo)

Update the information about specific MTS session

    Updates the information about an individual MTS session. As specified in ETSI GS MEC 009 [6], the PUT HTTP method has &#39;replace&#39; semantics. 

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionId** | **String**| Represents a MTS session instance | [default to null]
 **MtsSessionInfo** | [**MtsSessionInfo**](../Models/MtsSessionInfo.md)| MtsSessionInfo with updated information is included as entity body of the request. |

### Return type

[**MtsSessionInfo**](../Models/MtsSessionInfo.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json, application/problem+json

<a name="mtsSessionsListGET"></a>
# **mtsSessionsListGET**
> List mtsSessionsListGET(app\_instance\_id, app\_name, session\_id)

Retrieve information about a list of MTS sessions

    Retrieves information about a list of MTS sessions. Typically used in the &#39;Get configured MTS Session Info from the MTS Service&#39; procedure as described in clause 6.2.10.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **app\_instance\_id** | [**List**](../Models/String.md)| A MEC application instance may use multiple app_instance_ids as an input parameter to query the MTS session of a list of MEC application instances. See note. | [optional] [default to null]
 **app\_name** | [**List**](../Models/String.md)| A MEC application instance may use multiple app_names as an input parameter to query the MTS session of a list of MEC application instances. See note. | [optional] [default to null]
 **session\_id** | [**List**](../Models/String.md)| A MEC application instance may use session_id as an input parameter to query the information of a list of MTS sessions. See note. | [optional] [default to null]

### Return type

[**List**](../Models/MtsSessionInfo.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json, application/problem+json

