# BwmApi

All URIs are relative to *https://localhost/sandboxname/bwm/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**bandwidthAllocationDELETE**](BwmApi.md#bandwidthAllocationDELETE) | **DELETE** /bw_allocations/{allocationId} | Remove a specific bandwidthAllocation
[**bandwidthAllocationGET**](BwmApi.md#bandwidthAllocationGET) | **GET** /bw_allocations/{allocationId} | Retrieve information about a specific bandwidthAllocation
[**bandwidthAllocationListGET**](BwmApi.md#bandwidthAllocationListGET) | **GET** /bw_allocations | Retrieve information about a list of bandwidthAllocation resources
[**bandwidthAllocationPATCH**](BwmApi.md#bandwidthAllocationPATCH) | **PATCH** /bw_allocations/{allocationId} | Modify the information about a specific existing bandwidthAllocation by sending updates on the data structure
[**bandwidthAllocationPOST**](BwmApi.md#bandwidthAllocationPOST) | **POST** /bw_allocations | Create a bandwidthAllocation resource
[**bandwidthAllocationPUT**](BwmApi.md#bandwidthAllocationPUT) | **PUT** /bw_allocations/{allocationId} | Update the information about a specific bandwidthAllocation


<a name="bandwidthAllocationDELETE"></a>
# **bandwidthAllocationDELETE**
> bandwidthAllocationDELETE(allocationId)

Remove a specific bandwidthAllocation

    Used in &#39;Unregister from Bandwidth Management Service&#39; procedure as described in clause 6.2.3.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **allocationId** | **String**| Represents a bandwidth allocation instance | [default to null]

### Return type

null (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/problem+json

<a name="bandwidthAllocationGET"></a>
# **bandwidthAllocationGET**
> BwInfo bandwidthAllocationGET(allocationId)

Retrieve information about a specific bandwidthAllocation

    Retrieves information about a bandwidthAllocation resource. Typically used in &#39;Get configured bandwidth allocation from Bandwidth Management Service&#39; procedure as described in clause 6.2.5.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **allocationId** | **String**| Represents a bandwidth allocation instance | [default to null]

### Return type

[**BwInfo**](../Models/BwInfo.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json, application/problem+json

<a name="bandwidthAllocationListGET"></a>
# **bandwidthAllocationListGET**
> List bandwidthAllocationListGET(app\_instance\_id, app\_name, session\_id)

Retrieve information about a list of bandwidthAllocation resources

    Retrieves information about a list of bandwidthAllocation resources. Typically used in &#39;Get configured bandwidth allocation from Bandwidth Management Service&#39; procedure as described in clause 6.2.5.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **app\_instance\_id** | [**List**](../Models/String.md)| A MEC application instance may use multiple app_instance_ids as an input parameter to query the bandwidth allocation of a list of MEC application instances. app_instance_id corresponds to appInsId defined in table 7.2.2-1. See note. | [optional] [default to null]
 **app\_name** | [**List**](../Models/String.md)| A MEC application instance may use multiple app_names as an input parameter to query the bandwidth allocation of a list of MEC application instances. app_name corresponds to appName defined in table 7.2.2-1. See note. | [optional] [default to null]
 **session\_id** | [**List**](../Models/String.md)| A MEC application instance may use session_id as an input parameter to query the bandwidth allocation of a list of sessions. session_id corresponds to allocationId defined in table 7.2.2-1. See note. | [optional] [default to null]

### Return type

[**List**](../Models/BwInfo.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json, application/problem+json

<a name="bandwidthAllocationPATCH"></a>
# **bandwidthAllocationPATCH**
> BwInfo bandwidthAllocationPATCH(allocationId, BwInfoDeltas)

Modify the information about a specific existing bandwidthAllocation by sending updates on the data structure

    Updates the information about a bandwidthAllocation resource. As specified in ETSI GS MEC 009 [6], the PATCH HTTP method updates a resource on top of the existing resource state by just including the changes (&#39;deltas&#39;) in the request body.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **allocationId** | **String**| Represents a bandwidth allocation instance | [default to null]
 **BwInfoDeltas** | [**BwInfoDeltas**](../Models/BwInfoDeltas.md)| Description of the changes to instruct the server how to modify the resource representation. |

### Return type

[**BwInfo**](../Models/BwInfo.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json, application/problem+json

<a name="bandwidthAllocationPOST"></a>
# **bandwidthAllocationPOST**
> BwInfo bandwidthAllocationPOST(BwInfo)

Create a bandwidthAllocation resource

    Used to create a bandwidthAllocation resource. Typically used in &#39;Register to Bandwidth Management Service&#39; procedure as described in clause 6.2.1.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **BwInfo** | [**BwInfo**](../Models/BwInfo.md)| Entity body in the request contains BwInfo to be created. |

### Return type

[**BwInfo**](../Models/BwInfo.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json, application/problem+json

<a name="bandwidthAllocationPUT"></a>
# **bandwidthAllocationPUT**
> BwInfo bandwidthAllocationPUT(allocationId, BwInfo)

Update the information about a specific bandwidthAllocation

    Updates the information about a bandwidthAllocation resource. As specified in ETSI GS MEC 009 [6], the PUT HTTP method has &#39;replace&#39; semantics.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **allocationId** | **String**| Represents a bandwidth allocation instance | [default to null]
 **BwInfo** | [**BwInfo**](../Models/BwInfo.md)| BwInfo with updated information is included as entity body of the request. |

### Return type

[**BwInfo**](../Models/BwInfo.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json, application/problem+json

