/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Metrics Service REST API
 * Metrics Service provides metrics about the active scenario <p>**Micro-service**<br>[meep-metrics-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-metrics-engine) <p>**Type & Usage**<br>Platform Service used by control/monitoring software and possibly by edge applications that require metrics <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD.
    define(['expect.js', '../../src/index'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    factory(require('expect.js'), require('../../src/index'));
  } else {
    // Browser globals (root is window)
    factory(root.expect, root.AdvantEdgeMetricsServiceRestApi);
  }
}(this, function(expect, AdvantEdgeMetricsServiceRestApi) {
  'use strict';

  var instance;

  beforeEach(function() {
    instance = new AdvantEdgeMetricsServiceRestApi.MetricsApi();
  });

  describe('(package)', function() {
    describe('MetricsApi', function() {
      describe('postEventQuery', function() {
        it('should call postEventQuery successfully', function(done) {
          // TODO: uncomment, update parameter values for postEventQuery call and complete the assertions
          /*
          var params = new AdvantEdgeMetricsServiceRestApi.EventQueryParams();
          params.tags = [new AdvantEdgeMetricsServiceRestApi.Tag()];
          params.tags[0].name = "src";
          params.tags[0].value = "ue1-iperf";
          params.fields = ["event"]"event";
          params.scope = new AdvantEdgeMetricsServiceRestApi.Scope();
          params.scope.limit = 60;
          params.scope.duration = "10s";

          instance.postEventQuery(params, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(AdvantEdgeMetricsServiceRestApi.EventMetricList);
            expect(data.name).to.be.a('string');
            expect(data.name).to.be("event metrics");
            {
              let dataCtr = data.columns;
              expect(dataCtr).to.be.an(Array);
              expect(dataCtr).to.not.be.empty();
              for (let p in dataCtr) {
                let data = dataCtr[p];
                expect(data).to.be.a('string');
                expect(data).to.be("");
              }
            }
            {
              let dataCtr = data.values;
              expect(dataCtr).to.be.an(Array);
              expect(dataCtr).to.not.be.empty();
              for (let p in dataCtr) {
                let data = dataCtr[p];
                expect(data).to.be.a(AdvantEdgeMetricsServiceRestApi.EventMetric);
                expect(data.time).to.be.a('string');
                expect(data.time).to.be("2019-11-24T12:45:00-5:00");
                expect(data.event).to.be.a('string');
                expect(data.event).to.be("JSON-formatted mobility event ue1 to poa3");
              }
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('postHttpQuery', function() {
        it('should call postHttpQuery successfully', function(done) {
          // TODO: uncomment, update parameter values for postHttpQuery call and complete the assertions
          /*
          var params = new AdvantEdgeMetricsServiceRestApi.HttpQueryParams();
          params.tags = [new AdvantEdgeMetricsServiceRestApi.Tag()];
          params.tags[0].name = "src";
          params.tags[0].value = "ue1-iperf";
          params.fields = ["id"]"id";
          params.scope = new AdvantEdgeMetricsServiceRestApi.Scope();
          params.scope.limit = 60;
          params.scope.duration = "10s";

          instance.postHttpQuery(params, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(AdvantEdgeMetricsServiceRestApi.HttpMetricList);
            expect(data.name).to.be.a('string');
            expect(data.name).to.be("http metrics");
            {
              let dataCtr = data.columns;
              expect(dataCtr).to.be.an(Array);
              expect(dataCtr).to.not.be.empty();
              for (let p in dataCtr) {
                let data = dataCtr[p];
                expect(data).to.be.a('string');
                expect(data).to.be("");
              }
            }
            {
              let dataCtr = data.values;
              expect(dataCtr).to.be.an(Array);
              expect(dataCtr).to.not.be.empty();
              for (let p in dataCtr) {
                let data = dataCtr[p];
                expect(data).to.be.a(AdvantEdgeMetricsServiceRestApi.HttpMetric);
                expect(data.time).to.be.a('string');
                expect(data.time).to.be("2019-11-24T12:45:00-5:00");
                expect(data.id).to.be.a('number');
                expect(data.id).to.be(5);
                expect(data.endpoint).to.be.a('string');
                expect(data.endpoint).to.be("/location/v1/subscription/userTracking");
                expect(data.url).to.be.a('string');
                expect(data.url).to.be("/location/v1/subscription/userTracking?validQueryParam");
                expect(data.method).to.be.a('string');
                expect(data.method).to.be("GET");
                expect(data.respCode).to.be.a('string');
                expect(data.respCode).to.be("200");
                expect(data.respBody).to.be.a('string');
                expect(data.respBody).to.be("{}");
                expect(data.body).to.be.a('string');
                expect(data.body).to.be("{}");
                expect(data.procTime).to.be.a('string');
                expect(data.procTime).to.be("345");
                expect(data.loggerName).to.be.a('string');
                expect(data.loggerName).to.be("loc-serv");
                expect(data.direction).to.be.a('string');
                expect(data.direction).to.be("Request");
              }
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
      describe('postNetworkQuery', function() {
        it('should call postNetworkQuery successfully', function(done) {
          // TODO: uncomment, update parameter values for postNetworkQuery call and complete the assertions
          /*
          var params = new AdvantEdgeMetricsServiceRestApi.NetworkQueryParams();
          params.tags = [new AdvantEdgeMetricsServiceRestApi.Tag()];
          params.tags[0].name = "src";
          params.tags[0].value = "ue1-iperf";
          params.fields = ["lat"]"lat";
          params.scope = new AdvantEdgeMetricsServiceRestApi.Scope();
          params.scope.limit = 60;
          params.scope.duration = "10s";

          instance.postNetworkQuery(params, function(error, data, response) {
            if (error) {
              done(error);
              return;
            }
            // TODO: update response assertions
            expect(data).to.be.a(AdvantEdgeMetricsServiceRestApi.NetworkMetricList);
            expect(data.name).to.be.a('string');
            expect(data.name).to.be("network metrics");
            {
              let dataCtr = data.columns;
              expect(dataCtr).to.be.an(Array);
              expect(dataCtr).to.not.be.empty();
              for (let p in dataCtr) {
                let data = dataCtr[p];
                expect(data).to.be.a('string');
                expect(data).to.be("");
              }
            }
            {
              let dataCtr = data.values;
              expect(dataCtr).to.be.an(Array);
              expect(dataCtr).to.not.be.empty();
              for (let p in dataCtr) {
                let data = dataCtr[p];
                expect(data).to.be.a(AdvantEdgeMetricsServiceRestApi.NetworkMetric);
                expect(data.time).to.be.a('string');
                expect(data.time).to.be("2019-11-24T12:45:00-5:00");
                expect(data.lat).to.be.a('number');
                expect(data.lat).to.be(5);
                expect(data.ul).to.be.a('number');
                expect(data.ul).to.be(90.1);
                expect(data.dl).to.be.a('number');
                expect(data.dl).to.be(100.0);
                expect(data.ulos).to.be.a('number');
                expect(data.ulos).to.be(0.001);
                expect(data.dlos).to.be.a('number');
                expect(data.dlos).to.be(0.003);
              }
            }

            done();
          });
          */
          // TODO: uncomment and complete method invocation above, then delete this line and the next:
          done();
        });
      });
    });
  });

}));
