/*
 * Copyright (c) 2022  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE V2X Information Service REST API
 *
 * V2X Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC030 V2XI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/030/02.02.01_60/gs_MEC030v020201p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-vis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-vis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Note**<br>AdvantEDGE supports a selected subset of RNI API endpoints (see below) and a subset of subscription types.
 *
 * API version: 2.2.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

type ProvChgUuMbmsSubscription struct {
	Links *Links `json:"_links,omitempty"`
	// URI exposed by the client on which to receive notifications via HTTP. See note.
	CallbackReference string `json:"callbackReference,omitempty"`

	ExpiryDeadline *TimeStamp `json:"expiryDeadline,omitempty"`

	FilterCriteria *ProvChgUuMbmsSubscriptionFilterCriteria `json:"filterCriteria"`
	// Shall be set to TRUE by the service consumer to request a test notification via HTTP on the callbackReference URI, as described in ETSI GS MEC 009 [i.1], clause 6.12a. Default: FALSE.
	RequestTestNotification bool `json:"requestTestNotification,omitempty"`
	// Shall be set to \"ProvChgUuMbmsSubscription\".
	SubscriptionType string `json:"subscriptionType"`

	WebsockNotifConfig *WebsockNotifConfig `json:"websockNotifConfig,omitempty"`
}
