# mec_demo_3_api

MecDemo3Api - JavaScript client for mec_demo_3_api
Demo 3 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate MEC011 and MEC021 usage
This SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.1
- Package version: 0.0.1
- Build package: io.swagger.codegen.languages.JavascriptClientCodegen

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/),
please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install mec_demo_3_api --save
```

##### Local development

To use the library locally without publishing to a remote npm registry, first install the dependencies by changing 
into the directory containing `package.json` (and this README). Let's call this `JAVASCRIPT_CLIENT_DIR`. Then run:

```shell
npm install
```

Next, [link](https://docs.npmjs.com/cli/link) it globally in npm with the following, also from `JAVASCRIPT_CLIENT_DIR`:

```shell
npm link
```

Finally, switch to the directory you want to use your mec_demo_3_api from, and run:

```shell
npm link /path/to/<JAVASCRIPT_CLIENT_DIR>
```

You should now be able to `require('mec_demo_3_api')` in javascript files from the directory you ran the last 
command above from.

#### git
#
If the library is hosted at a git repository, e.g.
https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file, that's to say your javascript file where you actually 
use this library):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var MecDemo3Api = require('mec_demo_3_api');

var api = new MecDemo3Api.FrontendApi()

var device = null; // {Object} Delete device from AMS service resource


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
api.deleteAmsDevice(device, callback);

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MecDemo3Api.FrontendApi* | [**deleteAmsDevice**](docs/FrontendApi.md#deleteAmsDevice) | **DELETE** /service/ams/delete/{device} | Delete an AMS device
*MecDemo3Api.FrontendApi* | [**deregister**](docs/FrontendApi.md#deregister) | **DELETE** /info/application/delete | Deregister with MEC Platform and delete associated resources
*MecDemo3Api.FrontendApi* | [**getActivityLogs**](docs/FrontendApi.md#getActivityLogs) | **GET** /info/logs | Returns activity logs
*MecDemo3Api.FrontendApi* | [**getAmsDevices**](docs/FrontendApi.md#getAmsDevices) | **GET** /info/ams | Returns the list of AMS Devices
*MecDemo3Api.FrontendApi* | [**getPlatformInfo**](docs/FrontendApi.md#getPlatformInfo) | **GET** /info/application | Returns the application dynamic information
*MecDemo3Api.FrontendApi* | [**register**](docs/FrontendApi.md#register) | **POST** /register/app | Register with MEC Platform and create necessary resources
*MecDemo3Api.FrontendApi* | [**updateAmsDevices**](docs/FrontendApi.md#updateAmsDevices) | **PUT** /service/ams/update/{device} | Updates the list of AMS devices
*MecDemo3Api.NotificationApi* | [**amsNotificationCallback**](docs/NotificationApi.md#amsNotificationCallback) | **POST** /services/callback/amsevent | Callback endpoint for AMS Notifications
*MecDemo3Api.NotificationApi* | [**appTerminationNotificationCallback**](docs/NotificationApi.md#appTerminationNotificationCallback) | **POST** /application/termination | Callback endpoint for MEC011 app-termination notifications
*MecDemo3Api.NotificationApi* | [**contextTransferNotificationCallback**](docs/NotificationApi.md#contextTransferNotificationCallback) | **POST** /application/transfer | Callback endpoint for MEC021 context-state transfer notification
*MecDemo3Api.NotificationApi* | [**serviceAvailNotificationCallback**](docs/NotificationApi.md#serviceAvailNotificationCallback) | **POST** /services/callback/service-availability | Callback endpoint for MEC011 Notifications


## Documentation for Models



## Documentation for Authorization

 All endpoints do not require authorization.

