/*
 * Copyright (c) 2020  InterDigital Communications, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE GIS Engine REST API
 * This API allows to control geo-spatial behavior and simulation. <p>**Micro-service**<br>[meep-gis-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-gis-engine) <p>**Type & Usage**<br>Platform runtime interface to control geo-spatial behavior and simulation <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.AdvantEdgeGisEngineRestApi) {
      root.AdvantEdgeGisEngineRestApi = {};
    }
    root.AdvantEdgeGisEngineRestApi.AutomationState = factory(root.AdvantEdgeGisEngineRestApi.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';

  /**
   * The AutomationState model module.
   * @module model/AutomationState
   * @version 1.0.0
   */

  /**
   * Constructs a new <code>AutomationState</code>.
   * @alias module:model/AutomationState
   * @class
   */
  var exports = function() {
  };

  /**
   * Constructs a <code>AutomationState</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/AutomationState} obj Optional instance to populate.
   * @return {module:model/AutomationState} The populated <code>AutomationState</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();
      if (data.hasOwnProperty('type'))
        obj.type = ApiClient.convertToType(data['type'], 'String');
      if (data.hasOwnProperty('active'))
        obj.active = ApiClient.convertToType(data['active'], 'Boolean');
    }
    return obj;
  }

  /**
   * Automation type.<br> Automation loop evaluates enabled automation types once every second.<br> <p>Supported Types: <li>MOBILITY - Sends Mobility events to Sanbox Controller when UE changes POA. <li>MOVEMENT - Advances UEs along configured paths using previous position & velocity as inputs. <li>POAS-IN-RANGE - Sends POAS-IN-RANGE events to Sanbox Controller when list of POAs in range changes. <li>NETWORK-CHARACTERISTICS-UPDATE - Sends network characteristics update events to Sanbox Controller when throughput values change.
   * @member {module:model/AutomationState.TypeEnum} type
   */
  exports.prototype.type = undefined;

  /**
   * Automation feature state
   * @member {Boolean} active
   */
  exports.prototype.active = undefined;


  /**
   * Allowed values for the <code>type</code> property.
   * @enum {String}
   * @readonly
   */
  exports.TypeEnum = {
    /**
     * value: "MOBILITY"
     * @const
     */
    MOBILITY: "MOBILITY",

    /**
     * value: "MOVEMENT"
     * @const
     */
    MOVEMENT: "MOVEMENT",

    /**
     * value: "POAS-IN-RANGE"
     * @const
     */
    POAS_IN_RANGE: "POAS-IN-RANGE",

    /**
     * value: "NETWORK-CHARACTERISTICS-UPDATE"
     * @const
     */
    NETWORK_CHARACTERISTICS_UPDATE: "NETWORK-CHARACTERISTICS-UPDATE"
  };

  return exports;

}));
