# AdvantEDGE V2X Information System REST API

## Running the Server in Standalone mode

To run the server in standalone mode (for testing) i.e. without integrating it with AdvantEDGE, make the following changes:

- In _main.go_, replace the complete file with the following code:
  ```go
  package main

  import (
      "log"
      "net/http"

      sw "github.com/InterDigitalInc/AdvantEDGE/go-apps/meep-vis/server"
  )

  func main() {
      log.Printf("Server started")

      router := sw.NewRouter()

      log.Fatal(http.ListenAndServe(":8080", router))
  }
  ```
- In _go.mod_, add the following line in `replace`:
  ```go
  github.com/InterDigitalInc/AdvantEDGE/go-apps/meep-vis/server => ./server
  ```
- In _./server/vis.go_, remove all the code related to SBI and Redis. This includes
  - _sbi_ and _dkm_ imports
  - _Init()_, _Run()_ and _Stop()_ functions
- Run the server by using the command
  ```sh
  go run main.go
  ```
- Now the requests can be sent to
  ```
  http://localhost:8080/vis/v2/<endpoint>
  ```
