# Go API client for swagger

Demo 5 is an edge application that can be used with AdvantEDGE or ETSI MEC Sandbox to demonstrate EU application and MEC030 usage

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 0.0.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *http://10.190.115.162:8094*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DAIApi* | [**DaiAppListGET**](docs/DAIApi.md#daiapplistget) | **Get** /dai/apps | Returns onboarded-demo4 User Application AppContext
*DAIApi* | [**DaiAppLocationAvailabilityPOST**](docs/DAIApi.md#daiapplocationavailabilitypost) | **Post** /dai/availability/{appcontextid} | Obtain the location constraints for a new application context.
*DAIApi* | [**DaiDoPingDELETE**](docs/DAIApi.md#daidopingdelete) | **Delete** /dai/delete/{appcontextid} | Returns onboarded-demo4 User Application AppContext
*DAIApi* | [**DaiDoPingGET**](docs/DAIApi.md#daidopingget) | **Get** /dai/doping/{appcontextid} | Returns onboarded-demo4 User Application activity
*DAIApi* | [**DaiDoPingPOST**](docs/DAIApi.md#daidopingpost) | **Post** /dai/instantiate | Returns onboarded-demo4 User Application AppContext
*FrontendApi* | [**GetActivityLogs**](docs/FrontendApi.md#getactivitylogs) | **Get** /info/logs | Returns activity logs
*FrontendApi* | [**GetPlatformInfo**](docs/FrontendApi.md#getplatforminfo) | **Get** /info/application | Returns the application dynamic information
*NotificationApi* | [**AppTerminationNotificationCallback**](docs/NotificationApi.md#appterminationnotificationcallback) | **Post** /application/termination | Callback endpoint for MEC011 app-termination notifications
*NotificationApi* | [**ApplicationContextDeleteNotificationCallback**](docs/NotificationApi.md#applicationcontextdeletenotificationcallback) | **Post** /dai/callback/ApplicationContextDeleteNotification | Callback endpoint for MEC030 Notifications
*NotificationApi* | [**ServiceAvailNotificationCallback**](docs/NotificationApi.md#serviceavailnotificationcallback) | **Post** /services/callback/service-availability | Callback endpoint for MEC011 Notifications

## Documentation For Models

 - [AddressChangeNotification](docs/AddressChangeNotification.md)
 - [AppContext](docs/AppContext.md)
 - [AppContextAppInfo](docs/AppContextAppInfo.md)
 - [AppContextAppInfoUserAppInstanceInfo](docs/AppContextAppInfoUserAppInstanceInfo.md)
 - [AppTerminationSubscription](docs/AppTerminationSubscription.md)
 - [AppTerminationSubscriptionLinks](docs/AppTerminationSubscriptionLinks.md)
 - [ApplicationContextDeleteNotification](docs/ApplicationContextDeleteNotification.md)
 - [ApplicationContextState](docs/ApplicationContextState.md)
 - [ApplicationContextUpdateNotification](docs/ApplicationContextUpdateNotification.md)
 - [ApplicationContextUpdateNotificationUserAppInstanceInfo](docs/ApplicationContextUpdateNotificationUserAppInstanceInfo.md)
 - [ApplicationInstance](docs/ApplicationInstance.md)
 - [ApplicationInstanceAmsLinkListSubscription](docs/ApplicationInstanceAmsLinkListSubscription.md)
 - [ApplicationInstanceAppTerminationSubscription](docs/ApplicationInstanceAppTerminationSubscription.md)
 - [ApplicationInstanceDiscoveredServices](docs/ApplicationInstanceDiscoveredServices.md)
 - [ApplicationInstanceOfferedService](docs/ApplicationInstanceOfferedService.md)
 - [ApplicationInstanceSerAvailabilitySubscription](docs/ApplicationInstanceSerAvailabilitySubscription.md)
 - [ApplicationInstanceSubscriptions](docs/ApplicationInstanceSubscriptions.md)
 - [ApplicationList](docs/ApplicationList.md)
 - [ApplicationListAppInfo](docs/ApplicationListAppInfo.md)
 - [ApplicationListAppInfoAppCharcs](docs/ApplicationListAppInfoAppCharcs.md)
 - [ApplicationListAppList](docs/ApplicationListAppList.md)
 - [ApplicationListVendorSpecificExt](docs/ApplicationListVendorSpecificExt.md)
 - [ApplicationLocationAvailability](docs/ApplicationLocationAvailability.md)
 - [ApplicationLocationAvailabilityAppInfo](docs/ApplicationLocationAvailabilityAppInfo.md)
 - [ApplicationLocationAvailabilityAppInfoAvailableLocations](docs/ApplicationLocationAvailabilityAppInfoAvailableLocations.md)
 - [ApplicationLocationAvailabilityNotification](docs/ApplicationLocationAvailabilityNotification.md)
 - [AssociateId](docs/AssociateId.md)
 - [CommunicationInterface](docs/CommunicationInterface.md)
 - [InlineNotification](docs/InlineNotification.md)
 - [LinkType](docs/LinkType.md)
 - [LocalityType](docs/LocalityType.md)
 - [LocationConstraints](docs/LocationConstraints.md)
 - [LocationConstraintsCivicAddressElement](docs/LocationConstraintsCivicAddressElement.md)
 - [ModelType](docs/ModelType.md)
 - [OneOfInlineNotification](docs/OneOfInlineNotification.md)
 - [Polygon](docs/Polygon.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [ServiceAvailabilityNotification](docs/ServiceAvailabilityNotification.md)
 - [ServiceAvailabilityNotificationServiceReferences](docs/ServiceAvailabilityNotificationServiceReferences.md)
 - [ServiceState](docs/ServiceState.md)
 - [Subscription](docs/Subscription.md)
 - [TimeStamp](docs/TimeStamp.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author


