#!/bin/bash

#set -vx

# Get full path to script directory
SCRIPT=$(readlink -f "$0")
BASEDIR=$(dirname "$SCRIPT")

echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ">>> Dockerizing demo5 Server"
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
echo ""

DEMOBIN=$BASEDIR/bin/demo-server

# Copy frontend to static folder
#echo ">>> Copying Demo Server"
#cp -Rf $BASEDIR/bin/demo-frontend/* $DEMOBIN/static

# Copy Dockerfile & config to bin folder
cp $BASEDIR/src/backend/Dockerfile $DEMOBIN
# cp $BASEDIR/src/backend/app_instance.yaml $DEMOBIN
cp $BASEDIR/entrypoint.sh $DEMOBIN

echo ">>> Dockerizing"
cd $DEMOBIN
docker build --no-cache --rm -t meep-docker-registry:30001/demo5 .
docker push meep-docker-registry:30001/demo5
cd $BASEDIR

echo ""
echo ">>> Done"
