# Demo5
Demo5 scenario showcases the _Edge Platform Application Enablement_ and _VIS V2X message distribution_ edge services.

For more details, check out the [Demo5 Documentation](https://interdigitalinc.github.io/AdvantEDGE/docs/usage/usage-demo5/)

Demo5 scenario showcases the _Edge Platform Application Enablement_ and _VIS V2X message distribution_ edge services.

Demo5 application does not provide a dashboard GUI, tools such as cUrl or Postman can be used (see clause [demo5](#demo5))

## Demo5 Scenario Overview

The Demo5 scenario consists of one instances of a MEC application running on MEC platform. 
MEC-030 Service APIs provide the capability to implement V2X message distribution application. .

### demo5

The MEC application demo5 provide a simply HHTP REST APIs for MEC-030 in order to validate quickly MEC-030 support.

#### Check that the demo5 is up

The requets `GET /info/application` provides a description of the demo5 application.
```sh
$ curl "http://mec-platform.etsi.org:31111/info/application" -H "accept: application/json"
{"config":"app_instance.yaml","ip":"http://demo5-ue1:80","id":"ce454f4c-16f8-4542-83d8-c8afd45bcfea","mecReady":true,"subscriptions":{"AppTerminationSubscription":{"subId":"sub-LzNr62ED50GbZL_S"},"SerAvailabilitySubscription:":{"subId":"sub-Ec2tT-tKAe_qLxI7"}},"offeredService":{"serName":"demo5","id":"2ad0e566-2054-4550-ba97-1fe1f100fff0","state":"ACTIVE","scopeOfLocality":"MEC_SYSTEM","consumedLocalOnly":true},"discoveredServices":[{"serName":"meep-dai","serInstanceId":"70bb83a5-7ec7-4ab4-b889-ca7033a5be2b","consumedLocalOnly":true,"link":"http://mec-platform.etsi.org/usersb/dev_app/v1/","version":"2.0"},{"serName":"meep-rnis","serInstanceId":"3e72aa67-ff20-4e7e-bf21-aea928a1743b","consumedLocalOnly":true,"link":"http://mec-platform.etsi.org/usersb/rni/v2/","version":"2.0"},{"serName":"meep-ams","serInstanceId":"99e8a85d-5f87-48ed-be5e-1302c18e4664","consumedLocalOnly":true,"link":"http://mec-platform.etsi.org/usersb/amsi/v1/","version":"2.0"},{"serName":"meep-loc-serv","serInstanceId":"85ddf74d-d5e7-4d6f-beb5-25e97f8b57c9","consumedLocalOnly":true,"link":"http://mec-platform.etsi.org/usersb/location/v2/","version":"2.0"},{"serName":"meep-vis","serInstanceId":"3e23a210-8b1a-4a01-bc0c-1df7d1ad6be3","consumedLocalOnly":true,"link":"http://mec-platform.etsi.org/usersb/vis/v2/","version":"2.0"},{"serName":"meep-wais","serInstanceId":"a22f614e-a5c1-4902-84d3-4361ac9e3425","consumedLocalOnly":true,"link":"http://mec-platform.etsi.org/usersb/wai/v2/","version":"2.0"}]}
```

The requets `GET /info/logs` provides some executon logs for the demo5 application.
```sh
$ curl "http://mec-platform.etsi.org:31111/info/logs" -H "accept: application/json"
["5. demo5DaiAppListGET: applicationList succeed, len= 1","4. daiClient instance created","3. Subscribe to service-availability notification [201]","2. Subscribe to app-termination notification [201]","1. === Register Demo5 MEC Application [200]","0. Send confirm ready [204]"]
```

## Using Demo5


### Using Demo5 with AdvantEDGE

To use Demo5 as an AdvantEDGE scenario container:

- Build & dockerize Demo5 server & frontend
- Import the provided scenario demo5-scenario.yaml
- Create a sandbox & deploy Demo5 scenario
- Start Demo5 application frontend in browser

#### Build from source
To build demo5 & onboarded-demo5 from source code:
```sh
$ cd ~/AdvantEDGE/examples/demo5 
$ ./build-demo5.sh
```

NOTE: Binary files are created in ./bin/ folder

#### Dockerize demo applications
Demo Application binaries must be dockerized (containerized) as container images in the Docker registry. This step is necessary every time the demo binaries are updated.

NOTE: Make sure you have deployed the AdvantEDGE dependencies (e.g. docker registry) before dockerizing the demo binaries.

To generate docker images from demo binary files:

```sh
$ cd ~/AdvantEDGE/examples/demo5
$ ./dockerize.sh
```

### Using Demo5 with ETSI MEC Sandbox

To use Demo5 as an external application that interacts with the ETSI MEC Sandbox

- Build Demo5 server & frontend
- Log in to the [ETSI MEC Sandbox](https://try-mec.etsi.org)
- Deploy either of the dual-mep scenarios
- Configure Demo5 application instances
- Start Demo5 application instances
- Demo5 does not have prior knowledge or configuration information of the MEC services offered by the MEC platform.

Therefore, the following steps need to be done prior to running Demo5 application instances.

#### Obtain demo binaries
Use the same procedure described above for Demo5 with AdvantEDGE.

#### Create work directory for demo5 instance
Create a work directory of your choice on the system (e.g. ~/tmp/demo5) and copy the files ~/AdvantEDGE/examples/demo5/src/demo-server/demo5-config.yaml and ~/AdvantEDGE/examples/demo5/bin/demo-server/demo-server.

The structure should look like this:

```
~/tmp/demo5
     |
     \____ demo5-config.yaml
     |
     \____ demo-server
```

Update the configuration file demo5-config.yaml accordingly and launcg the demo application:

```sh
$ ./demo-server ./demo5-config.yaml
```
