# Go API client for swagger

The ETSI MEC ISG MEC011 MEC Service Management API described using OpenAPI

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 3.1.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *http://127.0.0.1:8081/mec_service_mgmt/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AppServicesApi* | [**AppServicesGET**](docs/AppServicesApi.md#appservicesget) | **Get** /applications/{appInstanceId}/services | get services
*AppServicesApi* | [**AppServicesPOST**](docs/AppServicesApi.md#appservicespost) | **Post** /applications/{appInstanceId}/services | create service
*AppServicesApi* | [**AppServicesServiceIdDELETE**](docs/AppServicesApi.md#appservicesserviceiddelete) | **Delete** /applications/{appInstanceId}/services/{serviceId} | delete service
*AppServicesApi* | [**AppServicesServiceIdGET**](docs/AppServicesApi.md#appservicesserviceidget) | **Get** /applications/{appInstanceId}/services/{serviceId} | get service
*AppServicesApi* | [**AppServicesServiceIdPUT**](docs/AppServicesApi.md#appservicesserviceidput) | **Put** /applications/{appInstanceId}/services/{serviceId} | update service
*AppSubscriptionsApi* | [**ApplicationsSubscriptionDELETE**](docs/AppSubscriptionsApi.md#applicationssubscriptiondelete) | **Delete** /applications/{appInstanceId}/subscriptions/{subscriptionId} | delete subscription
*AppSubscriptionsApi* | [**ApplicationsSubscriptionGET**](docs/AppSubscriptionsApi.md#applicationssubscriptionget) | **Get** /applications/{appInstanceId}/subscriptions/{subscriptionId} | Get subscription
*AppSubscriptionsApi* | [**ApplicationsSubscriptionsGET**](docs/AppSubscriptionsApi.md#applicationssubscriptionsget) | **Get** /applications/{appInstanceId}/subscriptions | Get subscriptions
*AppSubscriptionsApi* | [**ApplicationsSubscriptionsPOST**](docs/AppSubscriptionsApi.md#applicationssubscriptionspost) | **Post** /applications/{appInstanceId}/subscriptions | Create subscription
*IndividualMECserviceApi* | [**GetIndividualMECService**](docs/IndividualMECserviceApi.md#getindividualmecservice) | **Get** /resource_uri_allocated_by_MEC_platform | get mecServiceLiveness
*IndividualMECserviceApi* | [**PatchIndividualMECService**](docs/IndividualMECserviceApi.md#patchindividualmecservice) | **Patch** /resource_uri_allocated_by_MEC_platform | Update mecServiceLiveness
*ServicesApi* | [**ServicesGET**](docs/ServicesApi.md#servicesget) | **Get** /services | get services
*ServicesApi* | [**ServicesServiceIdGET**](docs/ServicesApi.md#servicesserviceidget) | **Get** /services/{serviceId} | get service
*TransportsApi* | [**TransportsGET**](docs/TransportsApi.md#transportsget) | **Get** /transports | Get transports

## Documentation For Models

 - [AppInstanceIdServicesBody](docs/AppInstanceIdServicesBody.md)
 - [CategoryRef](docs/CategoryRef.md)
 - [EndPointInfoAddress](docs/EndPointInfoAddress.md)
 - [EndPointInfoAddresses](docs/EndPointInfoAddresses.md)
 - [EndPointInfoAlternative](docs/EndPointInfoAlternative.md)
 - [EndPointInfoFqdn](docs/EndPointInfoFqdn.md)
 - [EndPointInfoUris](docs/EndPointInfoUris.md)
 - [LinkType](docs/LinkType.md)
 - [LocalityType](docs/LocalityType.md)
 - [MecServiceMgmtApiSubscriptionLinkList](docs/MecServiceMgmtApiSubscriptionLinkList.md)
 - [MecServiceMgmtApiSubscriptionLinkListLinks](docs/MecServiceMgmtApiSubscriptionLinkListLinks.md)
 - [MecServiceMgmtApiSubscriptionLinkListSubscription](docs/MecServiceMgmtApiSubscriptionLinkListSubscription.md)
 - [OneOfTransportInfoEndpoint](docs/OneOfTransportInfoEndpoint.md)
 - [OneOfappInstanceIdServicesBody](docs/OneOfappInstanceIdServicesBody.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [SecurityInfo](docs/SecurityInfo.md)
 - [SecurityInfoOAuth2Info](docs/SecurityInfoOAuth2Info.md)
 - [SecurityInfoOAuth2InfoGrantType](docs/SecurityInfoOAuth2InfoGrantType.md)
 - [Self](docs/Self.md)
 - [SerAvailabilityNotificationSubscription](docs/SerAvailabilityNotificationSubscription.md)
 - [SerAvailabilityNotificationSubscriptionFilteringCriteria](docs/SerAvailabilityNotificationSubscriptionFilteringCriteria.md)
 - [SerializerType](docs/SerializerType.md)
 - [ServiceAvailabilityNotification](docs/ServiceAvailabilityNotification.md)
 - [ServiceAvailabilityNotificationChangeType](docs/ServiceAvailabilityNotificationChangeType.md)
 - [ServiceAvailabilityNotificationServiceReferences](docs/ServiceAvailabilityNotificationServiceReferences.md)
 - [ServiceInfo](docs/ServiceInfo.md)
 - [ServiceInfoLinks](docs/ServiceInfoLinks.md)
 - [ServiceLivenessInfo](docs/ServiceLivenessInfo.md)
 - [ServiceLivenessInfoTimeStamp](docs/ServiceLivenessInfoTimeStamp.md)
 - [ServiceLivenessUpdate](docs/ServiceLivenessUpdate.md)
 - [ServiceState](docs/ServiceState.md)
 - [Subscription](docs/Subscription.md)
 - [TransportInfo](docs/TransportInfo.md)
 - [TransportType](docs/TransportType.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

cti_support@etsi.org
