# meep_metrics_engine_service_rest_api

MeepMetricsEngineServiceRestApi - JavaScript client for meep_metrics_engine_service_rest_api
Copyright (c) 2019  InterDigital Communications, Inc Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at      http://www.apache.org/licenses/LICENSE-2.0  Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License. 
This SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.JavascriptClientCodegen

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/),
please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install meep_metrics_engine_service_rest_api --save
```

##### Local development

To use the library locally without publishing to a remote npm registry, first install the dependencies by changing 
into the directory containing `package.json` (and this README). Let's call this `JAVASCRIPT_CLIENT_DIR`. Then run:

```shell
npm install
```

Next, [link](https://docs.npmjs.com/cli/link) it globally in npm with the following, also from `JAVASCRIPT_CLIENT_DIR`:

```shell
npm link
```

Finally, switch to the directory you want to use your meep_metrics_engine_service_rest_api from, and run:

```shell
npm link /path/to/<JAVASCRIPT_CLIENT_DIR>
```

You should now be able to `require('meep_metrics_engine_service_rest_api')` in javascript files from the directory you ran the last 
command above from.

#### git
#
If the library is hosted at a git repository, e.g.
https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file, that's to say your javascript file where you actually 
use this library):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var MeepMetricsEngineServiceRestApi = require('meep_metrics_engine_service_rest_api');

var api = new MeepMetricsEngineServiceRestApi.MetricsApi()

var opts = { 
  'dest': "dest_example", // {String} Pod where the log message is taken from
  'dataType': "dataType_example", // {String} Log Message Type
  'src': "src_example", // {String} Pod that originated the metrics logged in the message
  'starTime': "starTime_example", // {String} Starting timestamp of time range
  'stopTime': "stopTime_example" // {String} Ending timestamp of time range
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
api.metricsGet(opts, callback);

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MeepMetricsEngineServiceRestApi.MetricsApi* | [**metricsGet**](docs/MetricsApi.md#metricsGet) | **GET** /metrics | 


## Documentation for Models

 - [MeepMetricsEngineServiceRestApi.InlineResponse200](docs/InlineResponse200.md)
 - [MeepMetricsEngineServiceRestApi.LogResponse](docs/LogResponse.md)
 - [MeepMetricsEngineServiceRestApi.LogResponseData](docs/LogResponseData.md)
 - [MeepMetricsEngineServiceRestApi.LogResponseList](docs/LogResponseList.md)


## Documentation for Authorization

 All endpoints do not require authorization.

