/*
 * MEEP Location Service - Notification Callback
 *
 * Copyright (c) 2019  InterDigital Communications, Inc Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at      http://www.apache.org/licenses/LICENSE-2.0  Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 *
 * API version: 0.0.0
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

import (
	"time"
)

// Zonal or User tracking notification - callback generated toward an ME app with a zonal or user tracking subscription
type TrackingNotification struct {

	// CallBackData if passed by the application during the associated ZonalTrafficSubscription and UserTrackingSubscription operation. See [REST_NetAPI_Common].
	CallbackData string `json:"callbackData"`

	// Identifier of zone
	ZoneId string `json:"zoneId,omitempty"`

	// Address of user (e.g. \"sip\" URI, \"tel\" URI, \"acr\" URI).
	Address string `json:"address,omitempty"`

	// Interest realm of access point (e.g. geographical area, a type of industry etc.).
	InterestRealm string `json:"interestRealm,omitempty"`

	UserEventType *UserEventType `json:"userEventType,omitempty"`

	// Zone ID
	CurrentAccessPointId string `json:"currentAccessPointId,omitempty"`

	// Zone ID
	PreviousAccessPointId string `json:"previousAccessPointId,omitempty"`

	// Indicates the time of day for zonal presence notification.
	Timestamp time.Time `json:"timestamp,omitempty"`
}
