/*
 * Location API
 *
 * The ETSI MEC ISG MEC012 Location API described using OpenAPI. The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence
 *
 * API version: 1.1.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

import (
	"time"
)

// A type containing zonal presence notification
type ZonalPresenceNotification struct {

	// CallBackData if passed by the application during the associated ZonalTrafficSubscription and UserTrackingSubscription operation. See [REST_NetAPI_Common].
	CallbackData string `json:"callbackData,omitempty"`

	// Identifier of zone
	ZoneId string `json:"zoneId"`

	// Address of user (e.g. \"sip\" URI, \"tel\" URI, \"acr\" URI).
	Address string `json:"address"`

	// Interest realm of access point (e.g. geographical area, a type of industry etc.).
	InterestRealm string `json:"interestRealm,omitempty"`

	UserEventType *UserEventType `json:"userEventType"`

	// Zone ID
	CurrentAccessPointId string `json:"currentAccessPointId"`

	// Zone ID
	PreviousAccessPointId string `json:"previousAccessPointId,omitempty"`

	// Indicates the time of day for zonal presence notification.
	Timestamp time.Time `json:"timestamp"`

	// Link to other resources that are in relationship with this notification. The server SHOULD include a link to the related subscription. No other links are required or suggested by this specification.
	Link []Link `json:"link,omitempty"`
}
