/*
 * Location API
 *
 * The ETSI MEC ISG MEC012 Location API described using OpenAPI. The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence
 *
 * API version: 1.1.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

import (
	"time"
)

// A type containing access point information.
type AccessPointInfo struct {

	// Identifier of access point, <E-CGI><Cell Portion ID> (reference ETSI TS 129 171). Where the E-CGI is made up of the PLMN and Cell Identity (28 bit string). Then the PLMN is made up of the 3 digit MCC & 2 or 3 digit MNC. The Cell Portion is an optional element
	AccessPointId string `json:"accessPointId"`

	LocationInfo *LocationInfo `json:"locationInfo,omitempty"`

	ConnectionType *ConnectionType `json:"connectionType"`

	OperationStatus *OperationStatus `json:"operationStatus"`

	// The number of users currently on the access point.
	NumberOfUsers int32 `json:"numberOfUsers"`

	// Time zone of access point
	Timezone time.Time `json:"timezone,omitempty"`

	// Interest realm of access point (e.g. geographical area, a type of industry etc.).
	InterestRealm string `json:"interestRealm,omitempty"`

	// Self referring URL.
	ResourceURL string `json:"resourceURL"`
}
