/*
 * MEEP Controller REST API
 *
 * Copyright (c) 2019  InterDigital Communications, Inc Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at      http://www.apache.org/licenses/LICENSE-2.0  Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 *
 * API version: 1.0.0
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

// Logical zone (MEC network) object
type Zone struct {

	// Unique zone ID
	Id string `json:"id,omitempty"`

	// Zone name
	Name string `json:"name,omitempty"`

	// Zone type
	Type_ string `json:"type,omitempty"`

	// Latency in ms between fog nodes (or PoAs) within zone
	InterFogLatency int32 `json:"interFogLatency,omitempty"`

	// Latency variation in ms between fog nodes (or PoAs) within zone
	InterFogLatencyVariation int32 `json:"interFogLatencyVariation,omitempty"`

	// The limit of the traffic supported between fog nodes (or PoAs) within the zone
	InterFogThroughput int32 `json:"interFogThroughput,omitempty"`

	// Packet lost (in terms of percentage) between fog nodes (or PoAs) within the zone
	InterFogPacketLoss float64 `json:"interFogPacketLoss,omitempty"`

	// Latency in ms between edge nodes within zone
	InterEdgeLatency int32 `json:"interEdgeLatency,omitempty"`

	// Latency variation in ms between edge nodes within zone
	InterEdgeLatencyVariation int32 `json:"interEdgeLatencyVariation,omitempty"`

	// The limit of the traffic supported between edge nodes within the zone
	InterEdgeThroughput int32 `json:"interEdgeThroughput,omitempty"`

	// Packet lost (in terms of percentage) between edge nodes within the zone
	InterEdgePacketLoss float64 `json:"interEdgePacketLoss,omitempty"`

	// Latency in ms between fog nodes (or PoAs) and edge nodes within zone
	EdgeFogLatency int32 `json:"edgeFogLatency,omitempty"`

	// Latency variation in ms between fog nodes (or PoAs) and edge nodes within zone
	EdgeFogLatencyVariation int32 `json:"edgeFogLatencyVariation,omitempty"`

	// The limit of the traffic supported between fog nodes (or PoAs) and edge nodes within the zone
	EdgeFogThroughput int32 `json:"edgeFogThroughput,omitempty"`

	// Packet lost (in terms of percentage) between fog nodes (or PoAs) and edge nodes within the zone
	EdgeFogPacketLoss float64 `json:"edgeFogPacketLoss,omitempty"`

	// Key/Value Pair Map (string, string)
	Meta map[string]string `json:"meta,omitempty"`

	// Key/Value Pair Map (string, string)
	UserMeta map[string]string `json:"userMeta,omitempty"`

	NetworkLocations []NetworkLocation `json:"networkLocations,omitempty"`
}
