/**
 * MEEP Demo App API
 * Copyright (c) 2019  InterDigital Communications, Inc Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at      http://www.apache.org/licenses/LICENSE-2.0  Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License. 
 *
 * OpenAPI spec version: 0.0.1
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.3.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.MeepDemoAppApi) {
      root.MeepDemoAppApi = {};
    }
    root.MeepDemoAppApi.MobilityGroupAppState = factory(root.MeepDemoAppApi.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';




  /**
   * The MobilityGroupAppState model module.
   * @module model/MobilityGroupAppState
   * @version 0.0.1
   */

  /**
   * Constructs a new <code>MobilityGroupAppState</code>.
   * Mobility Group Application State
   * @alias module:model/MobilityGroupAppState
   * @class
   */
  var exports = function() {
    var _this = this;



  };

  /**
   * Constructs a <code>MobilityGroupAppState</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:model/MobilityGroupAppState} obj Optional instance to populate.
   * @return {module:model/MobilityGroupAppState} The populated <code>MobilityGroupAppState</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('ueId')) {
        obj['ueId'] = ApiClient.convertToType(data['ueId'], 'String');
      }
      if (data.hasOwnProperty('ueState')) {
        obj['ueState'] = ApiClient.convertToType(data['ueState'], 'String');
      }
    }
    return obj;
  }

  /**
   * Mobility Group UE Identifier
   * @member {String} ueId
   */
  exports.prototype['ueId'] = undefined;
  /**
   * Mobility Group Application State for provided UE
   * @member {String} ueState
   */
  exports.prototype['ueState'] = undefined;



  return exports;
}));


