/*
 * ETSI GS MEC 033 IoT API
 *
 * ETSI GS MEC 033 IoT API described using OpenAPI.
 *
 * API version: 3.1.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

// NOTE 1: Value indicates the priority in descending order, i.e. with 0 as the highest priority and 255 as the lowest         priority. NOTE 2: Some applications (like inline/tap) require two interfaces. The first interface in the case of inline/tap is on the         client (e.g. UE) side and the second on the core network (e.g. EPC) side.  
type TrafficRuleDescriptor struct {
	// Identifies the traffic rule.
	TrafficRuleId string `json:"trafficRuleId"`
	// Definition of filter type: per FLOW or PACKET  If it is per FLOW, the filter matches upstream (e.g. UE->EPC) packets and downstream (e.g. EPC->UE) packets are handled by the same context. 
	FilterType string `json:"filterType"`
	// Priority of this traffic rule within the range 0 to 255. If traffic rule conflicts, the one with higher priority take precedence. See note 1.
	Priority int32 `json:"priority"`
	// The filter used to identify specific flow/packets that need to be handled by the MEC host.
	TrafficFilter []TrafficFilter `json:"trafficFilter"`
	// Identifies the action of the MEC host data plane, when a packet matches the trafficFilter, the example actions include: DROP, FORWARD_DECAPSULATED, FORWARD_ENCAPSULATED, PASSTHROUGH, DUPLICATE_DECAPSULATED, DUPLICATE_ENCAPSULATED 
	Action string `json:"action"`
	DstInterface *InterfaceDescriptor `json:"dstInterface,omitempty"`
}
