/*
 * ETSI GS MEC 033 IoT API
 *
 * ETSI GS MEC 033 IoT API described using OpenAPI.
 *
 * API version: 3.1.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

type MbTransportInfo struct {
	// The identifier of this transport as per ETSI GS MEC 011 [i.2].
	Id string `json:"id"`
	// The name of this transport as per ETSI GS MEC 011 [i.2].
	Name string `json:"name"`
	// Human-readable description of this transport as per ETSI GS MEC 011 [i.2].
	Description string `json:"description,omitempty"`
	Type_ *TransportType `json:"type"`
	// The name of the protocol used. Being the transport of MB_TOPIC_BASED type, this attribute should be typically set to \"MQTT\" or \"AMQP.\"
	Protocol string `json:"protocol"`
	// The version of the protocol used as per ETSI GS MEC 011 [i.2].
	Version string `json:"version"`
	Endpoint *EndPointInfo `json:"endpoint"`
	Security *SecurityInfo `json:"security"`
	ImplSpecificInfo *ImplSpecificInfo `json:"implSpecificInfo"`
}
