/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Radio Network Information API
 *
 * Radio Network Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC012 RNI API](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/012/02.02.01_60/gs_MEC012v020201p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-rnis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-rnis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Note**<br>AdvantEDGE supports a selected subset of RNI API endpoints (see below) and a subset of subscription types. <p>Supported subscriptions: <p> - CellChangeSubscription <p> - RabEstSubscription <p> - RabRelSubscription <p> - MeasRepUeSubscription <p> - NrMeasRepUeSubscription
 *
 * API version: 2.2.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

// This type represents a subscription to S1-U bearer information notification from Radio Network Information Service. NOTE: At least one of callbackReference and websockNotifConfig shall be provided by the service consumer.       If both are provided, it is up to RNIS to choose an alternative and return only that alternative in the response,       specified in ETSI GS MEC 009 [6], as described in clause 6.12a.
type S1BearerSubscription struct {
	S1BearerSubscriptionCriteria *S1BearerSubscriptionS1BearerSubscriptionCriteria `json:"S1BearerSubscriptionCriteria"`
	Links                        *CaReconfSubscriptionLinks                        `json:"_links,omitempty"`
	// URI exposed by the client on which to receive notifications via HTTP. See note.
	CallbackReference  string              `json:"callbackReference"`
	WebsockNotifConfig *WebsockNotifConfig `json:"websockNotifConfig,omitempty"`
	// Shall be set to TRUE by the service consumer to request a test notification via HTTP on the callbackReference URI, specified in ETSI GS MEC 009 [6], as described in clause 6.12a.
	RequestTestNotification bool `json:"requestTestNotification,omitempty"`
	// Description of the subscribed event. The event is included both in the request and in the response. \\nFor the eventType, the following values are currently defined: <p>0 = RESERVED. <p>1 = S1_BEARER_ESTABLISH. <p>2 = S1_BEARER_MODIFY. <p>3 = S1_BEARER_RELEASE.
	EventType      []int32    `json:"eventType"`
	ExpiryDeadline *TimeStamp `json:"expiryDeadline,omitempty"`
	// Shall be set to \"S1BearerSubscription\".
	SubscriptionType string `json:"subscriptionType"`
}
