/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Metrics Service REST API
 *
 * Metrics Service provides metrics about the active scenario <p>**Micro-service**<br>[meep-metrics-engine](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-metrics-engine) <p>**Type & Usage**<br>Platform Service used by control/monitoring software and possibly by edge applications that require metrics <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * API version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

// Value of a single http metric
type HttpMetric struct {

	// Time of http metrics
	Time string `json:"time,omitempty"`

	// Http metrics identifier
	Id int32 `json:"id,omitempty"`

	// Http metrics queried endpoint
	Endpoint string `json:"endpoint,omitempty"`

	// Http metrics queried endpoint with query parameters
	Url string `json:"url,omitempty"`

	// Http metrics method
	Method string `json:"method,omitempty"`

	// Http metrics response status code
	RespCode string `json:"resp_code,omitempty"`

	// Http metrics response body
	RespBody string `json:"resp_body,omitempty"`

	// Http metrics body
	Body string `json:"body,omitempty"`

	// Request processing time in ms
	ProcTime string `json:"proc_time,omitempty"`

	// Service processing the http metric
	LoggerName string `json:"logger_name,omitempty"`

	// Http metric type (request, response, notification)
	MsgType string `json:"msg_type,omitempty"`

	// DEPRECATED -- Http type
	Direction string `json:"direction,omitempty"`
}
