# coding: utf-8

"""
    MEC Sandbox API

    The MEC Sandbox API described using OpenAPI  # noqa: E501

    OpenAPI spec version: 0.0.9
    Contact: cti_support@etsi.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class AuthorizationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_namespace(self, user_code, **kwargs):  # noqa: E501
        """Get the namespace against the User Code  # noqa: E501

        Get the namespace against the User Code  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespace(user_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_code: User Code obtained from the login endpoint (required)
        :return: Namespace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_namespace_with_http_info(user_code, **kwargs)  # noqa: E501
        else:
            (data) = self.get_namespace_with_http_info(user_code, **kwargs)  # noqa: E501
            return data

    def get_namespace_with_http_info(self, user_code, **kwargs):  # noqa: E501
        """Get the namespace against the User Code  # noqa: E501

        Get the namespace against the User Code  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_namespace_with_http_info(user_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_code: User Code obtained from the login endpoint (required)
        :return: Namespace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_namespace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_code' is set
        if ('user_code' not in params or
                params['user_code'] is None):
            raise ValueError("Missing the required parameter `user_code` when calling `get_namespace`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user_code' in params:
            query_params.append(('user_code', params['user_code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/namespace', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Namespace',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def login(self, provider, **kwargs):  # noqa: E501
        """Initiate OAuth login procedure and creates a MEC Sandbox instance  # noqa: E501

        Initiate OAuth login procedure and creates a MEC Sandbox instance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.login(provider, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str provider: Oauth provider (required)
        :return: Oauth
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.login_with_http_info(provider, **kwargs)  # noqa: E501
        else:
            (data) = self.login_with_http_info(provider, **kwargs)  # noqa: E501
            return data

    def login_with_http_info(self, provider, **kwargs):  # noqa: E501
        """Initiate OAuth login procedure and creates a MEC Sandbox instance  # noqa: E501

        Initiate OAuth login procedure and creates a MEC Sandbox instance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.login_with_http_info(provider, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str provider: Oauth provider (required)
        :return: Oauth
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['provider']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method login" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'provider' is set
        if ('provider' not in params or
                params['provider'] is None):
            raise ValueError("Missing the required parameter `provider` when calling `login`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'provider' in params:
            query_params.append(('provider', params['provider']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/login', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Oauth',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def logout(self, sandbox_name, **kwargs):  # noqa: E501
        """Terminates User Session and delete the Sandbox instance  # noqa: E501

        Terminates User Session and delete the Sandbox instance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.logout(sandbox_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sandbox_name: Sandbox identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.logout_with_http_info(sandbox_name, **kwargs)  # noqa: E501
        else:
            (data) = self.logout_with_http_info(sandbox_name, **kwargs)  # noqa: E501
            return data

    def logout_with_http_info(self, sandbox_name, **kwargs):  # noqa: E501
        """Terminates User Session and delete the Sandbox instance  # noqa: E501

        Terminates User Session and delete the Sandbox instance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.logout_with_http_info(sandbox_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sandbox_name: Sandbox identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sandbox_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method logout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sandbox_name' is set
        if ('sandbox_name' not in params or
                params['sandbox_name'] is None):
            raise ValueError("Missing the required parameter `sandbox_name` when calling `logout`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sandbox_name' in params:
            query_params.append(('sandbox_name', params['sandbox_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/logout', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
