/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Platform Controller REST API
 * This API is the main Platform Controller API for scenario configuration & sandbox management <p>**Micro-service**<br>[meep-pfm-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-platform-ctrl) <p>**Type & Usage**<br>Platform main interface used by controller software to configure scenarios and manage sandboxes in the AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
 *
 * OpenAPI spec version: 1.0.0
 * Contact: AdvantEDGE@InterDigital.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.4.9
 *
 * Do not edit the class manually.
 *
 */

(function(factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/CellularDomainConfig', 'model/CellularPoaConfig', 'model/ConnectivityConfig', 'model/CpuConfig', 'model/D2dConfig', 'model/DNConfig', 'model/Deployment', 'model/Domain', 'model/EgressService', 'model/ExternalConfig', 'model/GeoData', 'model/GpuConfig', 'model/IngressService', 'model/LineString', 'model/MemoryConfig', 'model/NetworkCharacteristics', 'model/NetworkLocation', 'model/PhysicalLocation', 'model/Poa4GConfig', 'model/Poa5GConfig', 'model/PoaWifiConfig', 'model/Point', 'model/Process', 'model/Sandbox', 'model/SandboxConfig', 'model/SandboxList', 'model/Scenario', 'model/ScenarioConfig', 'model/ScenarioList', 'model/ServiceConfig', 'model/ServicePort', 'model/Zone', 'api/SandboxControlApi', 'api/ScenarioConfigurationApi'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('./ApiClient'), require('./model/CellularDomainConfig'), require('./model/CellularPoaConfig'), require('./model/ConnectivityConfig'), require('./model/CpuConfig'), require('./model/D2dConfig'), require('./model/DNConfig'), require('./model/Deployment'), require('./model/Domain'), require('./model/EgressService'), require('./model/ExternalConfig'), require('./model/GeoData'), require('./model/GpuConfig'), require('./model/IngressService'), require('./model/LineString'), require('./model/MemoryConfig'), require('./model/NetworkCharacteristics'), require('./model/NetworkLocation'), require('./model/PhysicalLocation'), require('./model/Poa4GConfig'), require('./model/Poa5GConfig'), require('./model/PoaWifiConfig'), require('./model/Point'), require('./model/Process'), require('./model/Sandbox'), require('./model/SandboxConfig'), require('./model/SandboxList'), require('./model/Scenario'), require('./model/ScenarioConfig'), require('./model/ScenarioList'), require('./model/ServiceConfig'), require('./model/ServicePort'), require('./model/Zone'), require('./api/SandboxControlApi'), require('./api/ScenarioConfigurationApi'));
  }
}(function(ApiClient, CellularDomainConfig, CellularPoaConfig, ConnectivityConfig, CpuConfig, D2dConfig, DNConfig, Deployment, Domain, EgressService, ExternalConfig, GeoData, GpuConfig, IngressService, LineString, MemoryConfig, NetworkCharacteristics, NetworkLocation, PhysicalLocation, Poa4GConfig, Poa5GConfig, PoaWifiConfig, Point, Process, Sandbox, SandboxConfig, SandboxList, Scenario, ScenarioConfig, ScenarioList, ServiceConfig, ServicePort, Zone, SandboxControlApi, ScenarioConfigurationApi) {
  'use strict';

  /**
   * This_API_is_the_main_Platform_Controller_API_for_scenario_configuration__sandbox_management_pMicro_servicebr_meep_pfm_ctrl_httpsgithub_comInterDigitalIncAdvantEDGEtreemastergo_appsmeep_platform_ctrl_pType__UsagebrPlatform_main_interface_used_by_controller_software_to_configure_scenarios_and_manage_sandboxes_in_the_AdvantEDGE_platform_pDetailsbrAPI_details_available_at__your_AdvantEDGE_ip_addressapi_.<br>
   * The <code>index</code> module provides access to constructors for all the classes which comprise the public API.
   * <p>
   * An AMD (recommended!) or CommonJS application will generally do something equivalent to the following:
   * <pre>
   * var AdvantEdgePlatformControllerRestApi = require('index'); // See note below*.
   * var xxxSvc = new AdvantEdgePlatformControllerRestApi.XxxApi(); // Allocate the API class we're going to use.
   * var yyyModel = new AdvantEdgePlatformControllerRestApi.Yyy(); // Construct a model instance.
   * yyyModel.someProperty = 'someValue';
   * ...
   * var zzz = xxxSvc.doSomething(yyyModel); // Invoke the service.
   * ...
   * </pre>
   * <em>*NOTE: For a top-level AMD script, use require(['index'], function(){...})
   * and put the application logic within the callback function.</em>
   * </p>
   * <p>
   * A non-AMD browser application (discouraged) might do something like this:
   * <pre>
   * var xxxSvc = new AdvantEdgePlatformControllerRestApi.XxxApi(); // Allocate the API class we're going to use.
   * var yyy = new AdvantEdgePlatformControllerRestApi.Yyy(); // Construct a model instance.
   * yyyModel.someProperty = 'someValue';
   * ...
   * var zzz = xxxSvc.doSomething(yyyModel); // Invoke the service.
   * ...
   * </pre>
   * </p>
   * @module index
   * @version 1.0.0
   */
  var exports = {
    /**
     * The ApiClient constructor.
     * @property {module:ApiClient}
     */
    ApiClient: ApiClient,
    /**
     * The CellularDomainConfig model constructor.
     * @property {module:model/CellularDomainConfig}
     */
    CellularDomainConfig: CellularDomainConfig,
    /**
     * The CellularPoaConfig model constructor.
     * @property {module:model/CellularPoaConfig}
     */
    CellularPoaConfig: CellularPoaConfig,
    /**
     * The ConnectivityConfig model constructor.
     * @property {module:model/ConnectivityConfig}
     */
    ConnectivityConfig: ConnectivityConfig,
    /**
     * The CpuConfig model constructor.
     * @property {module:model/CpuConfig}
     */
    CpuConfig: CpuConfig,
    /**
     * The D2dConfig model constructor.
     * @property {module:model/D2dConfig}
     */
    D2dConfig: D2dConfig,
    /**
     * The DNConfig model constructor.
     * @property {module:model/DNConfig}
     */
    DNConfig: DNConfig,
    /**
     * The Deployment model constructor.
     * @property {module:model/Deployment}
     */
    Deployment: Deployment,
    /**
     * The Domain model constructor.
     * @property {module:model/Domain}
     */
    Domain: Domain,
    /**
     * The EgressService model constructor.
     * @property {module:model/EgressService}
     */
    EgressService: EgressService,
    /**
     * The ExternalConfig model constructor.
     * @property {module:model/ExternalConfig}
     */
    ExternalConfig: ExternalConfig,
    /**
     * The GeoData model constructor.
     * @property {module:model/GeoData}
     */
    GeoData: GeoData,
    /**
     * The GpuConfig model constructor.
     * @property {module:model/GpuConfig}
     */
    GpuConfig: GpuConfig,
    /**
     * The IngressService model constructor.
     * @property {module:model/IngressService}
     */
    IngressService: IngressService,
    /**
     * The LineString model constructor.
     * @property {module:model/LineString}
     */
    LineString: LineString,
    /**
     * The MemoryConfig model constructor.
     * @property {module:model/MemoryConfig}
     */
    MemoryConfig: MemoryConfig,
    /**
     * The NetworkCharacteristics model constructor.
     * @property {module:model/NetworkCharacteristics}
     */
    NetworkCharacteristics: NetworkCharacteristics,
    /**
     * The NetworkLocation model constructor.
     * @property {module:model/NetworkLocation}
     */
    NetworkLocation: NetworkLocation,
    /**
     * The PhysicalLocation model constructor.
     * @property {module:model/PhysicalLocation}
     */
    PhysicalLocation: PhysicalLocation,
    /**
     * The Poa4GConfig model constructor.
     * @property {module:model/Poa4GConfig}
     */
    Poa4GConfig: Poa4GConfig,
    /**
     * The Poa5GConfig model constructor.
     * @property {module:model/Poa5GConfig}
     */
    Poa5GConfig: Poa5GConfig,
    /**
     * The PoaWifiConfig model constructor.
     * @property {module:model/PoaWifiConfig}
     */
    PoaWifiConfig: PoaWifiConfig,
    /**
     * The Point model constructor.
     * @property {module:model/Point}
     */
    Point: Point,
    /**
     * The Process model constructor.
     * @property {module:model/Process}
     */
    Process: Process,
    /**
     * The Sandbox model constructor.
     * @property {module:model/Sandbox}
     */
    Sandbox: Sandbox,
    /**
     * The SandboxConfig model constructor.
     * @property {module:model/SandboxConfig}
     */
    SandboxConfig: SandboxConfig,
    /**
     * The SandboxList model constructor.
     * @property {module:model/SandboxList}
     */
    SandboxList: SandboxList,
    /**
     * The Scenario model constructor.
     * @property {module:model/Scenario}
     */
    Scenario: Scenario,
    /**
     * The ScenarioConfig model constructor.
     * @property {module:model/ScenarioConfig}
     */
    ScenarioConfig: ScenarioConfig,
    /**
     * The ScenarioList model constructor.
     * @property {module:model/ScenarioList}
     */
    ScenarioList: ScenarioList,
    /**
     * The ServiceConfig model constructor.
     * @property {module:model/ServiceConfig}
     */
    ServiceConfig: ServiceConfig,
    /**
     * The ServicePort model constructor.
     * @property {module:model/ServicePort}
     */
    ServicePort: ServicePort,
    /**
     * The Zone model constructor.
     * @property {module:model/Zone}
     */
    Zone: Zone,
    /**
     * The SandboxControlApi service constructor.
     * @property {module:api/SandboxControlApi}
     */
    SandboxControlApi: SandboxControlApi,
    /**
     * The ScenarioConfigurationApi service constructor.
     * @property {module:api/ScenarioConfigurationApi}
     */
    ScenarioConfigurationApi: ScenarioConfigurationApi
  };

  return exports;
}));
