/*
 * AdvantEDGE Location API
 *
 * Location Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC013 Location API](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/013/03.01.01_60/gs_mec013v030101p.pdf) <p>The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-loc-serv](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-loc-serv) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about Users (UE) and Zone locations <p>**Note**<br>AdvantEDGE supports all of Location API endpoints (see below).
 *
 * API version: 3.1.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

import (
	"fmt"
	"net/http"
	"strings"

	httpLog "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-http-logger"
	met "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-metrics"

	"github.com/gorilla/mux"
)

type Route struct {
	Name        string
	Method      string
	Pattern     string
	HandlerFunc http.HandlerFunc
}

type Routes []Route

func NewRouter() *mux.Router {
	var handler http.Handler
	router := mux.NewRouter().StrictSlash(true)
	for _, route := range routes {
		handler = route.HandlerFunc
		handler = Logger(handler, route.Name)
		handler = met.MetricsHandler(handler, sandboxName, serviceName)
		handler = httpLog.LogRx(handler)
		router.
			Methods(route.Method).
			Path(route.Pattern).
			Name(route.Name).
			Handler(handler)
	}

	// Path prefix router order is important
	// Service Api files
	handler = http.StripPrefix("/location/v3/api/", http.FileServer(http.Dir("./api/")))
	router.
		PathPrefix("/location/v3/api/").
		Name("Api").
		Handler(handler)
	// User supplied service API files
	handler = http.StripPrefix("/location/v3/user-api/", http.FileServer(http.Dir("./user-api/")))
	router.
		PathPrefix("/location/v3/user-api/").
		Name("UserApi").
		Handler(handler)

	return router
}

func Index(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello World!")
}

var routes = Routes{
	Route{
		"Index",
		"GET",
		"/location/v3/",
		Index,
	},

	Route{
		"ApByIdGET",
		strings.ToUpper("Get"),
		"/location/v3/queries/zones/{zoneId}/accessPoints/{accessPointId}",
		ApByIdGET,
	},

	Route{
		"ApGET",
		strings.ToUpper("Get"),
		"/location/v3/queries/zones/{zoneId}/accessPoints",
		ApGET,
	},

	Route{
		"AreaSubDELETE",
		strings.ToUpper("Delete"),
		"/location/v3/subscriptions/area/{subscriptionId}",
		AreaSubDELETE,
	},

	Route{
		"AreaSubGET",
		strings.ToUpper("Get"),
		"/location/v3/subscriptions/area/{subscriptionId}",
		AreaSubGET,
	},

	Route{
		"AreaSubListGET",
		strings.ToUpper("Get"),
		"/location/v3/subscriptions/area",
		AreaSubListGET,
	},

	Route{
		"AreaSubPOST",
		strings.ToUpper("Post"),
		"/location/v3/subscriptions/area",
		AreaSubPOST,
	},

	Route{
		"AreaSubPUT",
		strings.ToUpper("Put"),
		"/location/v3/subscriptions/area/{subscriptionId}",
		AreaSubPUT,
	},

	Route{
		"DistanceGET",
		strings.ToUpper("Get"),
		"/location/v3/queries/distance",
		DistanceGET,
	},

	Route{
		"DistanceSubDELETE",
		strings.ToUpper("Delete"),
		"/location/v3/subscriptions/distance/{subscriptionId}",
		DistanceSubDELETE,
	},

	Route{
		"DistanceSubGET",
		strings.ToUpper("Get"),
		"/location/v3/subscriptions/distance/{subscriptionId}",
		DistanceSubGET,
	},

	Route{
		"DistanceSubListGET",
		strings.ToUpper("Get"),
		"/location/v3/subscriptions/distance",
		DistanceSubListGET,
	},

	Route{
		"DistanceSubPOST",
		strings.ToUpper("Post"),
		"/location/v3/subscriptions/distance",
		DistanceSubPOST,
	},

	Route{
		"DistanceSubPUT",
		strings.ToUpper("Put"),
		"/location/v3/subscriptions/distance/{subscriptionId}",
		DistanceSubPUT,
	},

	Route{
		"Mec011AppTerminationPOST",
		strings.ToUpper("Post"),
		"/location/v3/notifications/mec011/appTermination",
		Mec011AppTerminationPOST,
	},

	Route{
		"UserSubListGET",
		strings.ToUpper("Get"),
		"/location/v3/subscriptions/users",
		UserSubListGET,
	},

	Route{
		"UserSubPOST",
		strings.ToUpper("Post"),
		"/location/v3/subscriptions/users",
		UserSubPOST,
	},
	Route{
		"UserSubGET",
		strings.ToUpper("Get"),
		"/location/v3/subscriptions/users/{subscriptionId}",
		UserSubGET,
	},
	Route{
		"UserSubDELETE",
		strings.ToUpper("Delete"),
		"/location/v3/subscriptions/users/{subscriptionId}",
		UserSubDELETE,
	},

	Route{
		"UserSubPUT",
		strings.ToUpper("Put"),
		"/location/v3/subscriptions/users/{subscriptionId}",
		UserSubPUT,
	},

	Route{
		"UsersGET",
		strings.ToUpper("Get"),
		"/location/v3/queries/users",
		UsersGET,
	},

	Route{
		"ZoneSubListGET",
		strings.ToUpper("Get"),
		"/location/v3/subscriptions/zones",
		ZoneSubListGET,
	},

	Route{
		"ZoneSubPOST",
		strings.ToUpper("Post"),
		"/location/v3/subscriptions/zones",
		ZoneSubPOST,
	},

	Route{
		"ZoneSubGET",
		strings.ToUpper("Get"),
		"/location/v3/subscriptions/zones/{subscriptionId}",
		ZoneSubGET,
	},

	Route{
		"ZoneSubDELETE",
		strings.ToUpper("Delete"),
		"/location/v3/subscriptions/zones/{subscriptionId}",
		ZoneSubDELETE,
	},
	Route{
		"zoneSubPUT",
		strings.ToUpper("Put"),
		"/location/v3/subscriptions/zones/{subscriptionId}",
		ZoneSubPUT,
	},

	Route{
		"ZonesGET",
		strings.ToUpper("Get"),
		"/location/v3/queries/zones",
		ZonesGET,
	},

	Route{
		"ZonesGetById",
		strings.ToUpper("Get"),
		"/location/v3/queries/zones/{zoneId}",
		ZonesGetById,
	},
}
