/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE Device application interface
 *
 * Device application interface is AdvantEDGE's implementation of [ETSI GS MEC016 Device application interface](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/030/02.02.01_60/gs_MEC016v020201p.pdf) <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-dai](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-dai) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Note**<br>AdvantEDGE supports a selected subset of DAI API endpoints (see below) and a subset of subscription types.
 *
 * API version: 2.2.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

import (
	"fmt"
	"net/http"
	"strings"

	httpLog "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-http-logger"
	met "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-metrics"

	"github.com/gorilla/mux"
)

type Route struct {
	Name        string
	Method      string
	Pattern     string
	HandlerFunc http.HandlerFunc
}

type Routes []Route

func NewRouter() *mux.Router {
	router := mux.NewRouter().StrictSlash(true)
	var handler http.Handler
	for _, route := range routes {
		handler = route.HandlerFunc
		handler = Logger(handler, route.Name)
		handler = met.MetricsHandler(handler, sandboxName, serviceName)
		handler = httpLog.LogRx(handler)
		router.
			Methods(route.Method).
			Path(route.Pattern).
			Name(route.Name).
			Handler(handler)
	}

	// Path prefix router order is important
	// Service Api files
	handler = http.StripPrefix("/dev_app/v1/api/", http.FileServer(http.Dir("./api/")))
	router.
		PathPrefix("/dev_app/v1/api/").
		Name("Api").
		Handler(handler)
	// User supplied service API files
	handler = http.StripPrefix("/dev_app/v1/user-api/", http.FileServer(http.Dir("./user-api/")))
	router.
		PathPrefix("/dev_app/v1/user-api/").
		Name("UserApi").
		Handler(handler)

	return router
}

func Index(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello World!")
}

var routes = Routes{
	Route{
		"Index",
		"GET",
		"/dev_app/v1/",
		Index,
	},

	Route{
		"Mec011AppTerminationPOST",
		strings.ToUpper("Post"),
		"/dev_app/v1/notifications/mec011/appTermination",
		Mec011AppTerminationPOST,
	},

	Route{
		"AppLocationAvailabilityPOST",
		strings.ToUpper("Post"),
		"/dev_app/v1/obtain_app_loc_availability",
		AppLocationAvailabilityPOST,
	},

	Route{
		"DevAppContextDELETE",
		strings.ToUpper("Delete"),
		"/dev_app/v1/app_contexts/{contextId}",
		DevAppContextDELETE,
	},

	Route{
		"DevAppContextPUT",
		strings.ToUpper("Put"),
		"/dev_app/v1/app_contexts/{contextId}",
		DevAppContextPUT,
	},

	Route{
		"DevAppContextsPOST",
		strings.ToUpper("Post"),
		"/dev_app/v1/app_contexts",
		DevAppContextsPOST,
	},

	Route{
		"MeAppListGET",
		strings.ToUpper("Get"),
		"/dev_app/v1/app_list",
		MeAppListGET,
	},

	Route{
		"IndividualSubscriptionDELETE",
		strings.ToUpper("Delete"),
		"/dev_app/v1/subscriptions/{subscriptionId}",
		IndividualSubscriptionDELETE,
	},
}
