/**
 * MEEP Metrics Engine Service REST API
 * Copyright (c) 2019  InterDigital Communications, Inc Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at      http://www.apache.org/licenses/LICENSE-2.0  Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License. 
 *
 * OpenAPI spec version: 1.0.0
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 *
 * Swagger Codegen version: 2.3.1
 *
 * Do not edit the class manually.
 *
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['ApiClient', 'model/LogResponseList'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../model/LogResponseList'));
  } else {
    // Browser globals (root is window)
    if (!root.MeepMetricsEngineServiceRestApi) {
      root.MeepMetricsEngineServiceRestApi = {};
    }
    root.MeepMetricsEngineServiceRestApi.MetricsApi = factory(root.MeepMetricsEngineServiceRestApi.ApiClient, root.MeepMetricsEngineServiceRestApi.LogResponseList);
  }
}(this, function(ApiClient, LogResponseList) {
  'use strict';

  /**
   * Metrics service.
   * @module api/MetricsApi
   * @version 1.0.0
   */

  /**
   * Constructs a new MetricsApi. 
   * @alias module:api/MetricsApi
   * @class
   * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
   * default to {@link module:ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the metricsGet operation.
     * @callback module:api/MetricsApi~metricsGetCallback
     * @param {String} error Error message, if any.
     * @param {module:model/LogResponseList} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Used to get a list of all metrics for a specific message type, destination pd and source pod combination
     * @param {Object} opts Optional parameters
     * @param {String} opts.dest Pod where the log message is taken from
     * @param {String} opts.dataType Log Message Type
     * @param {String} opts.src Pod that originated the metrics logged in the message
     * @param {String} opts.starTime Starting timestamp of time range
     * @param {String} opts.stopTime Ending timestamp of time range
     * @param {module:api/MetricsApi~metricsGetCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/LogResponseList}
     */
    this.metricsGet = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'dest': opts['dest'],
        'dataType': opts['dataType'],
        'src': opts['src'],
        'starTime': opts['starTime'],
        'stopTime': opts['stopTime'],
      };
      var collectionQueryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = [];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = LogResponseList;

      return this.apiClient.callApi(
        '/metrics', 'GET',
        pathParams, queryParams, collectionQueryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
