# DevAppApi

All URIs are relative to *https://localhost/dev_app/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**appLocationAvailabilityPOST**](DevAppApi.md#appLocationAvailabilityPOST) | **POST** /obtain_app_loc_availability | Obtain the location constraints for a new application context.
[**devAppContextDELETE**](DevAppApi.md#devAppContextDELETE) | **DELETE** /app_contexts/{contextId} | Deletion of an existing application context.
[**devAppContextPUT**](DevAppApi.md#devAppContextPUT) | **PUT** /app_contexts/{contextId} | Updating the callbackReference and/or appLocation of an existing application context.
[**devAppContextsPOST**](DevAppApi.md#devAppContextsPOST) | **POST** /app_contexts | Creation of a new application context.
[**meAppListGET**](DevAppApi.md#meAppListGET) | **GET** /app_list | Get available application information.


<a name="appLocationAvailabilityPOST"></a>
# **appLocationAvailabilityPOST**
> ApplicationLocationAvailability appLocationAvailabilityPOST(ApplicationLocationAvailability)

Obtain the location constraints for a new application context.

    Used to obtain the locations available for instantiation of a specific user application in the MEC system.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ApplicationLocationAvailability** | [**ApplicationLocationAvailability**](../Models/ApplicationLocationAvailability.md)| Entity body in the request contains the user application information for the MEC system to evaluate the locations available for instantiation of that application. |

### Return type

[**ApplicationLocationAvailability**](../Models/ApplicationLocationAvailability.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json, application/problem+json

<a name="devAppContextDELETE"></a>
# **devAppContextDELETE**
> devAppContextDELETE(contextId)

Deletion of an existing application context.

    Used to delete the resource that represents the existing application context.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contextId** | **String**| Uniquely identifies the application context in the MEC system. It is assigned by the MEC system. | [default to null]

### Return type

null (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/problem+json

<a name="devAppContextPUT"></a>
# **devAppContextPUT**
> devAppContextPUT(contextId, AppContext)

Updating the callbackReference and/or appLocation of an existing application context.

    Used to update the callback reference and/or application location constraints of an existing application context. Upon successful operation, the target resource is updated with the new application context information.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contextId** | **String**| Uniquely identifies the application context in the MEC system. It is assigned by the MEC system. | [default to null]
 **AppContext** | [**AppContext**](../Models/AppContext.md)| Only the callbackReference and/or appLocation attribute values are allowed to be updated. Other attributes and their values shall remain untouched. |

### Return type

null (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/problem+json

<a name="devAppContextsPOST"></a>
# **devAppContextsPOST**
> AppContext devAppContextsPOST(AppContext)

Creation of a new application context.

    Used to create a new application context. Upon success, the response contains entity body describing the created application context.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **AppContext** | [**AppContext**](../Models/AppContext.md)| Entity body in the request contains the Application Context as requested by the device application. |

### Return type

[**AppContext**](../Models/AppContext.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json, application/problem+json

<a name="meAppListGET"></a>
# **meAppListGET**
> ApplicationList meAppListGET(appName, appProvider, appSoftVersion, vendorId, serviceCont)

Get available application information.

    Used to query information about the available MEC applications.

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **appName** | [**List**](../Models/String.md)| Name to identify the MEC application. | [optional] [default to null]
 **appProvider** | [**List**](../Models/String.md)| Provider of the MEC application. | [optional] [default to null]
 **appSoftVersion** | [**List**](../Models/String.md)| Software version of the MEC application. | [optional] [default to null]
 **vendorId** | [**List**](../Models/String.md)| Vendor identifier | [optional] [default to null]
 **serviceCont** | **Integer**| Required service continuity mode for this application. Permitted values: 0 &#x3D; SERVICE_CONTINUITY_NOT_REQUIRED. 1 &#x3D; SERVICE_CONTINUITY_REQUIRED. | [optional] [default to null] [enum: 0, 1]

### Return type

[**ApplicationList**](../Models/ApplicationList.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json, application/problem+json

