/*
 * Copyright (c) 2024  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE WLAN Access Information API
 *
 * WLAN Access Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC028 WAI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/028/02.03.01_60/gs_MEC028v020301p.pdf) <p>[Copyright (c) ETSI 2020](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-wais](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-wais) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about WLAN access information in the network <p>**Note**<br>AdvantEDGE supports a selected subset of WAI API subscription types. <p>Supported subscriptions: <p> - AssocStaSubscription <p> - StaDataRateSubscription
 *
 * API version: 2.3.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

type MeasurementInfo struct {
	BeaconRequestConf *BeaconRequestConfig `json:"beaconRequestConf,omitempty"`
	ChannelLoadConf   *ChannelLoadConfig   `json:"channelLoadConf,omitempty"`
	// Duration of the measurement in Time Units (TUs) of 1 024 µs, as defined in clause 11.11.4 of IEEE 802.11-2016. If not provided, the underlying system may utilize a default configuration that will be indicated in resulting measurement reports.
	MeasurementDuration int32                 `json:"measurementDuration,omitempty"`
	NeighborReportConf  *NeighborReportConfig `json:"neighborReportConf,omitempty"`
	// Random interval to be used for starting the measurement in TUs of 1 024 µs, as specified in clause 11.11.3 of IEEE 802.11-2016. If not provided, the underlying system may utilize a default configuration that will be indicated in resulting measurement reports.
	RandomInterval    int32                `json:"randomInterval,omitempty"`
	StaStatisticsConf *StaStatisticsConfig `json:"staStatisticsConf,omitempty"`
}
