# Go API client for swagger

This API provides microservice API authentication & authorization services <p>**Micro-service**<br>[meep-auth](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-auth) <p>**Type & Usage**<br>Platform interface used by ingress to authenticate & authorize microservice API access <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to */auth/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthApi* | [**Authenticate**](docs/AuthApi.md#authenticate) | **Get** /authenticate | Authenticate service request
*AuthApi* | [**Authorize**](docs/AuthApi.md#authorize) | **Get** /authorize | OAuth authorization response endpoint
*AuthApi* | [**Login**](docs/AuthApi.md#login) | **Get** /login | Initiate OAuth login procedure
*AuthApi* | [**LoginSupported**](docs/AuthApi.md#loginsupported) | **Get** /loginSupported | Check if login is supported
*AuthApi* | [**LoginUser**](docs/AuthApi.md#loginuser) | **Post** /login | Start a session
*AuthApi* | [**Logout**](docs/AuthApi.md#logout) | **Get** /logout | Terminate a session
*AuthApi* | [**TriggerWatchdog**](docs/AuthApi.md#triggerwatchdog) | **Post** /watchdog | Send heartbeat to watchdog

## Documentation For Models

 - [LoginBody](docs/LoginBody.md)
 - [Sandbox](docs/Sandbox.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com
