/*
 * Copyright (c) 2022  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * MEEP Demo App API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * API version: 0.0.1
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package server

// Zonal or User tracking notification - callback generated toward an ME app with a zonal or user tracking subscription
type TrackingNotification struct {

	// CallBackData if passed by the application during the associated Subscription (Zone or User Tracking) operation
	CallbackData string `json:"callbackData"`

	// Unique Identifier of a Location Zone
	ZoneId string `json:"zoneId,omitempty"`

	// Address of the user or device based on the connected access point - address = acr:<UE IP address>
	Address string `json:"address,omitempty"`

	// Details about the access point, geographical position, industry, etc.
	InterestRealm string `json:"interestRealm,omitempty"`

	UserEventType *UserEventType `json:"userEventType,omitempty"`

	// Unique identifier of a point of access
	CurrentAccessPointId string `json:"currentAccessPointId,omitempty"`

	// Unique identifier of a point of access
	PreviousAccessPointId string `json:"previousAccessPointId,omitempty"`

	Timestamp *TimeStamp `json:"timestamp,omitempty"`
}
