/*
 * ETSI GS MEC 033 IoT API
 *
 * ETSI GS MEC 033 IoT API described using OpenAPI.
 *
 * API version: 3.1.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

// NOTE 1: At least one attribute among gpsi, pei, supi, msisdn, imei, imsi, and iccid should be provided. Sufficient security         measures shall be put in place when any attribute among PEI, SUPI, IMEI, and IMSI is disclosed over the API. NOTE 2: Until a valid traffic rule is not provided, the device will not be able to use the IoTS. A valid traffic rule is provided         by one of the following options:         • the requestedMecTrafficRule attribute;         • the requestedIotPlatformId attribute when the IoT platform offers only one user transport;         • the combination of requestedIotPlatformId and requestedUserTransportId. NOTE 3: Enabled is a pseudo-attribute which needs to be maintained by the IoTS based on the presence or not of a valid         traffic rule associated to the device. It cannot be set directly by the service consumer.  
type DeviceInfo struct {
	// Information needed for secondary authentication of the IoT device to the data network - see ETSI TS 129 561 [i.4] and ETSI TS 129 061 [i.5] for 5G and LTE procedures, respectively. This attribute is implementation dependent and should be logically linked to the identifiers of the IoT device listed hereafter.
	DeviceAuthenticationInfo string `json:"deviceAuthenticationInfo"`
	// Additional information about the IoT device. This attribute is implementation dependent and may be expressed as an array of keyvalue pairs. 
	DeviceMetadata []KeyValuePair `json:"deviceMetadata,omitempty"`
	// GPSI of the IoT device if 5G-enabled (see note 1).
	Gpsi string `json:"gpsi,omitempty"`
	// PEI of the IoT device if 5G-enabled (see note 1).
	Pei string `json:"pei,omitempty"`
	// SUPI of the IoT device if 5G-enabled (see note 1).
	Supi string `json:"supi,omitempty"`
	// MSISDN of the IoT device if LTE-enabled (see note 1).
	Msisdn string `json:"msisdn,omitempty"`
	// IMEI of the IoT device if LTE-enabled (see note 1).
	Imei string `json:"imei,omitempty"`
	// IMSI of the IoT device if LTE-enabled (see note 1).
	Imsi string `json:"imsi,omitempty"`
	// ICCID of the IoT device (see note 1).
	Iccid string `json:"iccid,omitempty"`
	// Human-readable identifier of the IoT device.
	DeviceId string `json:"deviceId"`
	// MEC traffic rules the IoT device is requested to be associated to (see note 2). The data type definition is as per ETSI GS MEC 010-2 [i.6].
	RequestedMecTrafficRule []TrafficRuleDescriptor `json:"requestedMecTrafficRule,omitempty"`
	// IoT platform to which the IoT device is requested to be associated to (see note 2).
	RequestedIotPlatformId string `json:"requestedIotPlatformId,omitempty"`
	// User transport to which the IoT device is requested to be associated to (see note 2).
	RequestedUserTransportId string `json:"requestedUserTransportId,omitempty"`
	DeviceSpecificMessageFormats *DeviceSpecificMessageFormats `json:"deviceSpecificMessageFormats,omitempty"`
	DownlinkInfo *DownlinkInfo `json:"downlinkInfo,omitempty"`
	// Client-side SSL/TLS certificate to be used by the MEC IoTS to interact with the user transport provided by the associated IoT platform in case the MEC IoTS acts on behalf of the IoT device.
	ClientCertificate string `json:"clientCertificate,omitempty"`
	// Indication whether the IoT device has a valid associated traffic rule (TRUE) or not (FALSE). See note 3.
	Enabled bool `json:"enabled"`
}
