/*
 * ETSI GS MEC 046 Sensors Sharing Service APIs
 *
 * GS MEC 046 Sensors Sharing Service APIs described using OpenAPI.
 *
 * API version: 3.1.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

import (
	"fmt"
	"net/http"
	"strings"

	httpLog "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-http-logger"
	met "github.com/InterDigitalInc/AdvantEDGE/go-packages/meep-metrics"

	"github.com/gorilla/mux"
)

type Route struct {
	Name        string
	Method      string
	Pattern     string
	HandlerFunc http.HandlerFunc
}

type Routes []Route

func NewRouter() *mux.Router {
	var handler http.Handler
	router := mux.NewRouter().StrictSlash(true)
	for _, route := range routes {
		handler = route.HandlerFunc
		handler = Logger(handler, route.Name)
		handler = met.MetricsHandler(handler, sandboxName, serviceName)
		handler = httpLog.LogRx(handler)
		router.
			Methods(route.Method).
			Path(route.Pattern).
			Name(route.Name).
			Handler(handler)
	}

	// Path prefix router order is important
	// Service Api files
	handler = http.StripPrefix("/sens/v1/api/", http.FileServer(http.Dir("./api/")))
	router.
		PathPrefix("/sens/v1/api/").
		Name("Api").
		Handler(handler)
	// User supplied service API files
	handler = http.StripPrefix("/sens/v1/user-api/", http.FileServer(http.Dir("./user-api/")))
	router.
		PathPrefix("/sens/v1/user-api/").
		Name("UserApi").
		Handler(handler)

	return router
}

func Index(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello World!")
}

var routes = Routes{
	Route{
		"Index",
		"GET",
		"/sens/v1/",
		Index,
	},

	Route{
		"SensorMgmtPUT",
		strings.ToUpper("Put"),
		"/sens/v1/sensor_management",
		SensorMgmtPUT,
	},

	Route{
		"SensorDataLookupGET",
		strings.ToUpper("Get"),
		"/sens/v1/queries/status_data",
		SensorDataLookupGET,
	},

	Route{
		"SensorDataIndividualSubscriptionGET",
		strings.ToUpper("Get"),
		"/sens/v1/queries/status_data/{subscriptionId}",
		SensorDataIndividualSubscriptionGET,
	},

	Route{
		"SensorDataSubscriptionDELETE",
		strings.ToUpper("Delete"),
		"/sens/v1/queries/status_data/{subscriptionId}",
		SensorDataSubscriptionDELETE,
	},

	Route{
		"SensorDataSubscriptionGET",
		strings.ToUpper("Get"),
		"/sens/v1/subscriptions/sensor_data",
		SensorDataSubscriptionGET,
	},

	Route{
		"SensorDataSubscriptionPOST",
		strings.ToUpper("Post"),
		"/sens/v1/subscriptions/sensor_data",
		SensorDataSubscriptionPOST,
	},

	Route{
		"SensorDataSubscriptionPUT",
		strings.ToUpper("Put"),
		"/sens/v1/queries/status_data/{subscriptionId}",
		SensorDataSubscriptionPUT,
	},

	Route{
		"SensorDiscoveryLookupGET",
		strings.ToUpper("Get"),
		"/sens/v1/queries/sensor_discovery",
		SensorDiscoveryLookupGET,
	},

	Route{
		"SensorDiscoveryIndividualSubscriptionGET",
		strings.ToUpper("Get"),
		"/sens/v1/subscriptions/sensor_discovery/{subscriptionId}",
		SensorDiscoveryIndividualSubscriptionGET,
	},

	Route{
		"SensorDiscoverySubscriptionDELETE",
		strings.ToUpper("Delete"),
		"/sens/v1/subscriptions/sensor_discovery/{subscriptionId}",
		SensorDiscoverySubscriptionDELETE,
	},

	Route{
		"SensorDiscoverySubscriptionGET",
		strings.ToUpper("Get"),
		"/sens/v1/subscriptions/sensor_discovery",
		SensorDiscoverySubscriptionGET,
	},

	Route{
		"SensorDiscoverySubscriptionPOST",
		strings.ToUpper("Post"),
		"/sens/v1/subscriptions/sensor_discovery",
		SensorDiscoverySubscriptionPOST,
	},

	Route{
		"SensorDiscoverySubscriptionPUT",
		strings.ToUpper("Put"),
		"/sens/v1/subscriptions/sensor_discovery/{subscriptionId}",
		SensorDiscoverySubscriptionPUT,
	},

	Route{
		"SensorMgmtGET",
		strings.ToUpper("Get"),
		"/sens/v1/sensor_management",
		SensorMgmtGET,
	},

	Route{
		"SensorStatusLookupGET",
		strings.ToUpper("Get"),
		"/sens/v1/queries/sensor_status",
		SensorStatusLookupGET,
	},

	Route{
		"SensorSatusIndividualSubscriptionGET",
		strings.ToUpper("Get"),
		"/sens/v1/subscriptions/sensor_status/{subscriptionId}",
		SensorSatusIndividualSubscriptionGET,
	},

	Route{
		"SensorStatusIndividualSubscriptionGET",
		strings.ToUpper("Get"),
		"/sens/v1/subscriptions/sensor_status",
		SensorStatusIndividualSubscriptionGET,
	},

	Route{
		"SensorStatusSubscriptionDELETE",
		strings.ToUpper("Delete"),
		"/sens/v1/subscriptions/sensor_status/{subscriptionId}",
		SensorStatusSubscriptionDELETE,
	},

	Route{
		"SensorStatusSubscriptionPUT",
		strings.ToUpper("Put"),
		"/sens/v1/subscriptions/sensor_status/{subscriptionId}",
		SensorStatusSubscriptionPUT,
	},

	Route{
		"SensorStatusSubscriptionPOST",
		strings.ToUpper("Post"),
		"/sens/v1/subscriptions/sensor_status",
		SensorStatusSubscriptionPOST,
	},

	Route{
		"Mec011AppTerminationPOST",
		strings.ToUpper("Post"),
		"/sens/v1/notifications/mec046/appTermination",
		Mec011AppTerminationPOST,
	},
}
