# Go API client for client

Location Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC013 Location API](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/013/03.01.01_60/gs_mec013v030101p.pdf) <p>The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-loc-serv](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-loc-serv) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about Users (UE) and Zone locations <p>**Note**<br>AdvantEDGE supports all of Location API endpoints (see below).

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 3.1.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.go.GoClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```golang
import "./client"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/location/v3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*LocationApi* | [**ApByIdGET**](docs/LocationApi.md#apbyidget) | **Get** /queries/zones/{zoneId}/accessPoints/{accessPointId} | Radio Node Location Lookup
*LocationApi* | [**ApGET**](docs/LocationApi.md#apget) | **Get** /queries/zones/{zoneId}/accessPoints | Radio Node Location Lookup
*LocationApi* | [**AreaSubDELETE**](docs/LocationApi.md#areasubdelete) | **Delete** /subscriptions/area/{subscriptionId} | Cancel a subscription
*LocationApi* | [**AreaSubGET**](docs/LocationApi.md#areasubget) | **Get** /subscriptions/area/{subscriptionId} | Retrieve subscription information
*LocationApi* | [**AreaSubListGET**](docs/LocationApi.md#areasublistget) | **Get** /subscriptions/area | Retrieves information about the subscriptions for this requestor.
*LocationApi* | [**AreaSubPOST**](docs/LocationApi.md#areasubpost) | **Post** /subscriptions/area | Creates subscription to area notifications.
*LocationApi* | [**AreaSubPUT**](docs/LocationApi.md#areasubput) | **Put** /subscriptions/area/{subscriptionId} | Updates a subscription information
*LocationApi* | [**DistanceGET**](docs/LocationApi.md#distanceget) | **Get** /queries/distance | UE Distance Lookup of a specific UE
*LocationApi* | [**DistanceSubDELETE**](docs/LocationApi.md#distancesubdelete) | **Delete** /subscriptions/distance/{subscriptionId} | Cancel a subscription
*LocationApi* | [**DistanceSubGET**](docs/LocationApi.md#distancesubget) | **Get** /subscriptions/distance/{subscriptionId} | Retrieve user distance subscription information
*LocationApi* | [**DistanceSubListGET**](docs/LocationApi.md#distancesublistget) | **Get** /subscriptions/distance | Retrieves all active subscriptions to distance change notifications
*LocationApi* | [**DistanceSubPOST**](docs/LocationApi.md#distancesubpost) | **Post** /subscriptions/distance | Creates a subscription for distance change notification
*LocationApi* | [**DistanceSubPUT**](docs/LocationApi.md#distancesubput) | **Put** /subscriptions/distance/{subscriptionId} | Updates a user distance subscription information
*LocationApi* | [**Mec011AppTerminationPOST**](docs/LocationApi.md#mec011appterminationpost) | **Post** /notifications/mec011/appTermination | MEC011 Application Termination notification for self termination
*LocationApi* | [**UserSubDELETE**](docs/LocationApi.md#usersubdelete) | **Delete** /subscriptions/users/{subscriptionId} | Cancel a subscription
*LocationApi* | [**UserSubGET**](docs/LocationApi.md#usersubget) | **Get** /subscriptions/users/{subscriptionId} | Retrieve subscription information
*LocationApi* | [**UserSubListGET**](docs/LocationApi.md#usersublistget) | **Get** /subscriptions/users | Retrieves information about the subscriptions for the requestor
*LocationApi* | [**UserSubPOST**](docs/LocationApi.md#usersubpost) | **Post** /subscriptions/users | Create subscription to UE location notifications.
*LocationApi* | [**UserSubPUT**](docs/LocationApi.md#usersubput) | **Put** /subscriptions/users/{subscriptionId} | Updates a subscription information
*LocationApi* | [**UsersGET**](docs/LocationApi.md#usersget) | **Get** /queries/users | UE Location Lookup of a specific UE or group of UEs
*LocationApi* | [**ZoneSubListGET**](docs/LocationApi.md#zonesublistget) | **Get** /subscriptions/zones | Retrieves all active subscriptions to zone notifications
*LocationApi* | [**ZoneSubPOST**](docs/LocationApi.md#zonesubpost) | **Post** /subscriptions/zones | Creates a subscription to zone notifications
*LocationApi* | [**ZonesGET**](docs/LocationApi.md#zonesget) | **Get** /queries/zones | Zones information Lookup
*LocationApi* | [**ZonesGetById**](docs/LocationApi.md#zonesgetbyid) | **Get** /queries/zones/{zoneId} | Zones information Lookup

## Documentation For Models

 - [AccessPointInfo](docs/AccessPointInfo.md)
 - [AccessPointList](docs/AccessPointList.md)
 - [AppTerminationNotification](docs/AppTerminationNotification.md)
 - [AppTerminationNotificationLinks](docs/AppTerminationNotificationLinks.md)
 - [AreaInfo](docs/AreaInfo.md)
 - [AreaSubscriptionIdBody](docs/AreaSubscriptionIdBody.md)
 - [CivicAddress](docs/CivicAddress.md)
 - [ConnectionType](docs/ConnectionType.md)
 - [DistanceCriteria](docs/DistanceCriteria.md)
 - [InlineAccessPointInfo](docs/InlineAccessPointInfo.md)
 - [InlineAccessPointList](docs/InlineAccessPointList.md)
 - [InlineNotificationSubscriptionList](docs/InlineNotificationSubscriptionList.md)
 - [InlineProblemDetails](docs/InlineProblemDetails.md)
 - [InlineProblemDetailsRequired](docs/InlineProblemDetailsRequired.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse201](docs/InlineResponse201.md)
 - [InlineResponse2011](docs/InlineResponse2011.md)
 - [InlineTerminalDistance](docs/InlineTerminalDistance.md)
 - [InlineUserAreaNotification](docs/InlineUserAreaNotification.md)
 - [InlineUserAreaSubscription](docs/InlineUserAreaSubscription.md)
 - [InlineUserDistanceNotification](docs/InlineUserDistanceNotification.md)
 - [InlineUserDistanceSubscription](docs/InlineUserDistanceSubscription.md)
 - [InlineUserList](docs/InlineUserList.md)
 - [InlineUserLocationEventNotification](docs/InlineUserLocationEventNotification.md)
 - [InlineUserLocationEventSubscription](docs/InlineUserLocationEventSubscription.md)
 - [InlineUserLocationPeriodicNotification](docs/InlineUserLocationPeriodicNotification.md)
 - [InlineUserLocationPeriodicSubscription](docs/InlineUserLocationPeriodicSubscription.md)
 - [InlineZoneInfo](docs/InlineZoneInfo.md)
 - [InlineZoneList](docs/InlineZoneList.md)
 - [InlineZoneLocationEventNotification](docs/InlineZoneLocationEventNotification.md)
 - [InlineZoneLocationEventSubscription](docs/InlineZoneLocationEventSubscription.md)
 - [InlineZoneStatusNotification](docs/InlineZoneStatusNotification.md)
 - [InlineZoneStatusSubscription](docs/InlineZoneStatusSubscription.md)
 - [LinkType](docs/LinkType.md)
 - [Links](docs/Links.md)
 - [LocationEventType](docs/LocationEventType.md)
 - [LocationInfo](docs/LocationInfo.md)
 - [MapInfo](docs/MapInfo.md)
 - [NotificationResult](docs/NotificationResult.md)
 - [NotificationSubscriptionList](docs/NotificationSubscriptionList.md)
 - [OccurrenceInfo](docs/OccurrenceInfo.md)
 - [OperationActionType](docs/OperationActionType.md)
 - [OperationStatus](docs/OperationStatus.md)
 - [Origin](docs/Origin.md)
 - [PeriodicEventInfo](docs/PeriodicEventInfo.md)
 - [Point](docs/Point.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [RelativeLocationInfo](docs/RelativeLocationInfo.md)
 - [ReportingCtrl](docs/ReportingCtrl.md)
 - [RetrievalStatus](docs/RetrievalStatus.md)
 - [ServiceError](docs/ServiceError.md)
 - [Subscription](docs/Subscription.md)
 - [SubscriptionsAreaBody](docs/SubscriptionsAreaBody.md)
 - [SubscriptionsUsersBody](docs/SubscriptionsUsersBody.md)
 - [SubscriptionsZonesBody](docs/SubscriptionsZonesBody.md)
 - [TerminalDistance](docs/TerminalDistance.md)
 - [TerminalLocation](docs/TerminalLocation.md)
 - [TimeStamp](docs/TimeStamp.md)
 - [UserAreaNotification](docs/UserAreaNotification.md)
 - [UserAreaNotificationLinks](docs/UserAreaNotificationLinks.md)
 - [UserAreaSubscription](docs/UserAreaSubscription.md)
 - [UserDistanceNotification](docs/UserDistanceNotification.md)
 - [UserDistanceSubscription](docs/UserDistanceSubscription.md)
 - [UserEventPara](docs/UserEventPara.md)
 - [UserInfo](docs/UserInfo.md)
 - [UserList](docs/UserList.md)
 - [UserLocationEventNotification](docs/UserLocationEventNotification.md)
 - [UserLocationEventSubscription](docs/UserLocationEventSubscription.md)
 - [UserLocationPeriodicNotification](docs/UserLocationPeriodicNotification.md)
 - [UserLocationPeriodicSubscription](docs/UserLocationPeriodicSubscription.md)
 - [UsersSubscriptionIdBody](docs/UsersSubscriptionIdBody.md)
 - [Velocity](docs/Velocity.md)
 - [WebsockNotifConfig](docs/WebsockNotifConfig.md)
 - [ZoneInfo](docs/ZoneInfo.md)
 - [ZoneList](docs/ZoneList.md)
 - [ZoneLocationEventNotification](docs/ZoneLocationEventNotification.md)
 - [ZoneLocationEventSubscription](docs/ZoneLocationEventSubscription.md)
 - [ZoneStatusNotification](docs/ZoneStatusNotification.md)
 - [ZoneStatusSubscription](docs/ZoneStatusSubscription.md)

## Documentation For Authorization
 Endpoints do not require authorization.


## Author

AdvantEDGE@InterDigital.com
