/*
 * Copyright (c) 2024  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE V2X Information Service REST API
 *
 * V2X Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC030 V2XI API](.https://www.etsi.org/deliver/etsi_gs/MEC/001_099/030/03.02.01_60/) <p>[Copyright (c) ETSI 2024](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-vis](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-vis) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about radio conditions in the network <p>**Note**<br>AdvantEDGE supports a selected subset of VIS API endpoints (see below) and a subset of subscription types.
 *
 * API version: 3.2.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

type ProvChgPc5Notification struct {
	// For sidelink communication, the Destination Layer-2 ID is set to the ProSe Layer-2 Group ID or Prose UE ID, see ETSI TS 136 321 [i.12].
	DstLayer2Id  string        `json:"dstLayer2Id,omitempty"`
	LocationInfo *LocationInfo `json:"locationInfo"`
	// The information of the neighbour cells in a visiting PLMN that support V2X communication over PC5.
	NeighbourCellInfo []Pc5NeighbourCellInfo `json:"neighbourCellInfo,omitempty"`
	// Shall be set to \"ProvChgPc5Notification\".
	NotificationType string     `json:"notificationType"`
	TimeStamp        *TimeStamp `json:"timeStamp,omitempty"`
}
