/*
 * Copyright (c) 2024  The AdvantEDGE Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * AdvantEDGE WLAN Access Information API
 *
 * WLAN Access Information Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC028 WAI API](http://www.etsi.org/deliver/etsi_gs/MEC/001_099/028/02.03.01_60/gs_MEC028v020301p.pdf) <p>[Copyright (c) ETSI 2020](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-wais](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-wais) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about WLAN access information in the network <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_ <p>AdvantEDGE supports a selected subset of WAI API subscription types. <p>Supported subscriptions: <p> - AssocStaSubscription
 *
 * API version: 2.3.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package client

// Set for trigger-based event notification reporting.
type AllOfNotificationEvent struct {
	// Downlink data rate threshold for StaDataRate reporting.
	DownlinkRateThreshold int32 `json:"downlinkRateThreshold,omitempty"`
	// Number of connected stations threshold for trigger-based event reporting.
	Threshold int32 `json:"threshold,omitempty"`
	// Trigger event for the notification: 1 = Notification issued when the STA’s downlink data rate is greater than or equal to the downlink threshold 2 = Notification issued when the STA’s downlink data rate is less than or equal to the downlink threshold 3 = Notification issued when the STA’s uplink data rate is greater than or equal to the uplink threshold 4 = Notification issued when the STA’s uplink data rate is less than or equal to the uplink threshold 5 = Notification issued when the STA’s downlink and uplink data rate is greater than or equal to their thresholds 6 = Notification issued when the STA’s downlink and uplink data rate is less than or equal to their thresholds 7 = Notification issued when the STA’s downlink or uplink data rate is greater than or equal to their thresholds 8 = Notification issued when the STA’s downlink or uplink data rate is less than or equal to their thresholds
	Trigger int32 `json:"trigger"`
	// Uplink data rate threshold for StaDataRate reporting.
	UplinkRateThreshold int32 `json:"uplinkRateThreshold,omitempty"`
}
