/*
 * AdvantEDGE Location API
 *
 * Location Service is AdvantEDGE's implementation of [ETSI MEC ISG MEC013 Location API](https://www.etsi.org/deliver/etsi_gs/MEC/001_099/013/03.01.01_60/gs_mec013v030101p.pdf) <p>The API is based on the Open Mobile Alliance's specification RESTful Network API for Zonal Presence <p>[Copyright (c) ETSI 2017](https://forge.etsi.org/etsi-forge-copyright-notice.txt) <p>**Micro-service**<br>[meep-loc-serv](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-loc-serv) <p>**Type & Usage**<br>Edge Service used by edge applications that want to get information about Users (UE) and Zone locations <p>**Note**<br>AdvantEDGE supports all of Location API endpoints (see below).
 *
 * API version: 3.1.1
 * Contact: AdvantEDGE@InterDigital.com
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

// Indicates a Civic address
type CivicAddress struct {
	// The two-letter ISO 3166 country code in capital ASCII letters, e.g., DE or US
	Country string `json:"country"`
	// National subdivisions (state, canton, region, province, prefecture)
	A1 string `json:"A1,omitempty"`
	// County, parish, gun (JP), district (IN)
	A2 string `json:"A2,omitempty"`
	// City, township, shi (JP)
	A3 string `json:"A3,omitempty"`
	// City division, borough, city district, ward, chou (JP)
	A4 string `json:"A4,omitempty"`
	// Neighbourhood, block
	A5 string `json:"A5,omitempty"`
	// Group of streets below the neighbourhood level
	A6 string `json:"A6,omitempty"`
	// Leading street direction
	PRD string `json:"PRD,omitempty"`
	// Trailing street suffix
	POD string `json:"POD,omitempty"`
	// Street suffix or type
	STS string `json:"STS,omitempty"`
	// House number
	HNO string `json:"HNO,omitempty"`
	// House number suffix
	HNS string `json:"HNS,omitempty"`
	// Landmark or vanity address
	LMK string `json:"LMK,omitempty"`
	// Additional location information
	LOC string `json:"LOC,omitempty"`
	// Name (residence and office occupant)
	NAM string `json:"NAM,omitempty"`
	// Postal/zip code
	PC string `json:"PC,omitempty"`
	// Building (structure)
	BLD string `json:"BLD,omitempty"`
	// Unit (apartment, suite)
	UNIT string `json:"UNIT,omitempty"`
	// Floor
	FLR string `json:"FLR,omitempty"`
	// Room
	ROOM string `json:"ROOM,omitempty"`
	// Place-type
	PLC string `json:"PLC,omitempty"`
	// Postal community name
	PCN string `json:"PCN,omitempty"`
	// Post office box (P.O. box)
	POBOX string `json:"POBOX,omitempty"`
	// Additional code
	ADDCODE string `json:"ADDCODE,omitempty"`
	// Seat (desk, cubicle, workstation)
	SEAT string `json:"SEAT,omitempty"`
	// Primary road or street
	RD string `json:"RD,omitempty"`
	// Road clause
	RDSEC string `json:"RDSEC,omitempty"`
	// Road branch
	RDBR string `json:"RDBR,omitempty"`
	// Road sub-branch
	RDSUBBR string `json:"RDSUBBR,omitempty"`
	// Road pre-modifier
	PRM string `json:"PRM,omitempty"`
	// Road post-modifier
	POM string `json:"POM,omitempty"`
	// When present, this IE shall carry the value of \"usagerules\" Element of the PIDL-LO XML document, with UTF-8 encoding.
	UsageRules string `json:"usageRules,omitempty"`
	// When present, this IE shall contain the method token, carried by the \"method\" Element of the PIDLLO XML document.
	Method string `json:"method,omitempty"`
	// When present, this IE shall carry the value of \"provided-by\" Element of the PIDL-LO XML document, with UTF-8 encoding.
	ProvidedBy string `json:"providedBy,omitempty"`
}
