package sssmgr

type SssMgrBindingProtocol interface {
	init(tm *SssMgr) (err error)
	send(p_ctx SssMgrBindingProtocolContext) (err error, resp interface{})
	//(p_op string, p_type string, p_to string, p_from string, p_ri string, p_rev []string, p_bodyMap map[string]map[string]interface{}) (err error, resp map[string]map[string]interface{})
	notify(p_resp string) (err error)
	uninit() (err error)
}

type SssMgrBindingProtocolContext struct {
	host    string
	port    int
	name    string
	to      string
	from    string
	op      int
	ty      int
	rqi     string
	rvi     []string
	queries map[string]string
	body    map[string]map[string]interface{}
	code    int
}

/**
TS-0001 V4.22 Table 9.6.2.3-1: Types of parameters in accessControlOperations
TS-0004 V4.22 Table 6.3.4.2.5 1: Interpretation of m2m:operation
**/
