/*
 * ETSI GS MEC 033 IoT API
 *
 * ETSI GS MEC 033 IoT API described using OpenAPI.
 *
 * API version: 3.1.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

type TrafficFilter struct {
	// An IP address or a range of IP addresses. For IPv4, the IP address could be an IP address plus mask, or an individual IP address, or a range of IP addresses. For IPv6, the IP address could be an IP prefix, or a range of IP prefixes.
	SrcAddress []string `json:"srcAddress,omitempty"`
	// An IP address or a range of IP addresses. For IPv4, the IP address could be an IP address plus mask, or an individual IP address, or a range of IP addresses. For IPv6, the IP address could be an IP prefix, or a range of IP prefixes.
	DstAddress []string `json:"dstAddress,omitempty"`
	// A port or a range of ports.
	SrcPort []string `json:"srcPort,omitempty"`
	// A port or a range of ports.
	DstPort []string `json:"dstPort,omitempty"`
	// Specify the protocol of the traffic filter.
	Protocol []string `json:"protocol,omitempty"`
	// Used for tag based traffic rule.
	Tag []string `json:"tag,omitempty"`
	// An URI label, in application layer, i.e. in HTTP message, is used to filter the traffic.
	Uri []string `json:"uri,omitempty"`
	// A customized packet label in network layer, as defined by the owner of the MEC platform, is used to filter the traffic.
	PacketLabel []string `json:"packetLabel,omitempty"`
	// Used for GTP tunnel based traffic rule.
	SrcTunnelAddress []string `json:"srcTunnelAddress,omitempty"`
	// Used for GTP tunnel based traffic rule.
	TgtTunnelAddress []string `json:"tgtTunnelAddress,omitempty"`
	// Used for GTP tunnel based traffic rule.
	SrcTunnelPort []string `json:"srcTunnelPort,omitempty"`
	// Used for GTP tunnel based traffic rule.
	DstTunnelPort []string `json:"dstTunnelPort,omitempty"`
	// Used to match all packets that have the same QCI.
	QCI int32 `json:"qCI,omitempty"`
	// Used to match all IPv4 packets that have the same DSCP.
	DSCP int32 `json:"dSCP,omitempty"`
	// Used to match all IPv6 packets that have the same TC.
	TC int32 `json:"tC,omitempty"`
}
