/*
 * MEC Sandbox API
 *
 * The MEC Sandbox API described using OpenAPI
 *
 * API version: 0.0.9
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package client

// Logical network location object
type NetworkLocation struct {
	// Unique network location ID
	Id string `json:"id,omitempty"`
	// Network location name
	Name string `json:"name,omitempty"`
	// Network location type
	Type_ string `json:"type,omitempty"`
	NetChar *NetworkCharacteristics `json:"netChar,omitempty"`
	// **DEPRECATED** As of release 1.5.0, replaced by netChar latency
	TerminalLinkLatency int32 `json:"terminalLinkLatency,omitempty"`
	// **DEPRECATED** As of release 1.5.0, replaced by netChar latencyVariation
	TerminalLinkLatencyVariation int32 `json:"terminalLinkLatencyVariation,omitempty"`
	// **DEPRECATED** As of release 1.5.0, replaced by netChar throughputUl and throughputDl
	TerminalLinkThroughput int32 `json:"terminalLinkThroughput,omitempty"`
	// **DEPRECATED** As of release 1.5.0, replaced by netChar packetLoss
	TerminalLinkPacketLoss float64 `json:"terminalLinkPacketLoss,omitempty"`
	// Key/Value Pair Map (string, string)
	Meta map[string]string `json:"meta,omitempty"`
	// Key/Value Pair Map (string, string)
	UserMeta map[string]string `json:"userMeta,omitempty"`
	CellularPoaConfig *CellularPoaConfig `json:"cellularPoaConfig,omitempty"`
	Poa4GConfig *Poa4GConfig `json:"poa4GConfig,omitempty"`
	Poa5GConfig *Poa5GConfig `json:"poa5GConfig,omitempty"`
	PoaWifiConfig *PoaWifiConfig `json:"poaWifiConfig,omitempty"`
	GeoData *GeoData `json:"geoData,omitempty"`
	PhysicalLocations []PhysicalLocation `json:"physicalLocations,omitempty"`
}
