/*
 * MEC Service Management API
 *
 * The ETSI MEC ISG MEC011 MEC Service Management API described using OpenAPI
 *
 * API version: 3.1.1
 * Contact: cti_support@etsi.org
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */
package server

import (
	"time"
)

// Describes the parameters to perform EEC Registration related operations.
type EecRegistration struct {
	// Represents a unique identifier of the EEC.
	EecId string `json:"eecId"`

	UeId string `json:"ueId,omitempty"`
	// Profiles of ACs for which the EEC provides edge enabling services.
	AcProfs []AcProfile `json:"acProfs,omitempty"`

	ExpTime *time.Time `json:"expTime,omitempty"`
	// Profiles of ACs for which the EEC provides edge enabling services.
	EecSvcContSupp []AcrScenario `json:"eecSvcContSupp,omitempty"`
	// Identifier of the EEC context obtained from a previous registration.
	EecCntxId string `json:"eecCntxId,omitempty"`
	// Identifier of the EES that provided EEC context ID.
	SrcEesId string `json:"srcEesId,omitempty"`

	EndPt *EndPoint `json:"endPt,omitempty"`
	// Set to true to indicate that UE Mobility support is required. Set to false to indicate that UE mobility support is not required. The default value when omitted is false.
	UeMobilityReq bool `json:"ueMobilityReq,omitempty"`
	// Set to true to indicate the EES support for EAS selection. Set to false to indicate the EES shall not select the EAS. The default value when omitted is false.
	EasSelReqInd bool `json:"easSelReqInd,omitempty"`

	UeType *DeviceType `json:"ueType,omitempty"`
}
