# advant_edge_sandbox_controller_rest_api

AdvantEdgeSandboxControllerRestApi - JavaScript client for advant_edge_sandbox_controller_rest_api
This API is the main Sandbox Controller API for scenario deployment & event injection <p>**Micro-service**<br>[meep-sandbox-ctrl](https://github.com/InterDigitalInc/AdvantEDGE/tree/master/go-apps/meep-sandbox-ctrl) <p>**Type & Usage**<br>Platform runtime interface to manage active scenarios and inject events in AdvantEDGE platform <p>**Details**<br>API details available at _your-AdvantEDGE-ip-address/api_
This SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.JavascriptClientCodegen

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/),
please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install advant_edge_sandbox_controller_rest_api --save
```

##### Local development

To use the library locally without publishing to a remote npm registry, first install the dependencies by changing 
into the directory containing `package.json` (and this README). Let's call this `JAVASCRIPT_CLIENT_DIR`. Then run:

```shell
npm install
```

Next, [link](https://docs.npmjs.com/cli/link) it globally in npm with the following, also from `JAVASCRIPT_CLIENT_DIR`:

```shell
npm link
```

Finally, switch to the directory you want to use your advant_edge_sandbox_controller_rest_api from, and run:

```shell
npm link /path/to/<JAVASCRIPT_CLIENT_DIR>
```

You should now be able to `require('advant_edge_sandbox_controller_rest_api')` in javascript files from the directory you ran the last 
command above from.

#### git
#
If the library is hosted at a git repository, e.g.
https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file, that's to say your javascript file where you actually 
use this library):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var AdvantEdgeSandboxControllerRestApi = require('advant_edge_sandbox_controller_rest_api');

var api = new AdvantEdgeSandboxControllerRestApi.ActiveScenarioApi()

var name = "name_example"; // {String} Scenario name

var opts = { 
  'activationInfo': new AdvantEdgeSandboxControllerRestApi.ActivationInfo() // {ActivationInfo} Activation information
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
api.activateScenario(name, opts, callback);

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/sandboxname/sandbox-ctrl/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdvantEdgeSandboxControllerRestApi.ActiveScenarioApi* | [**activateScenario**](docs/ActiveScenarioApi.md#activateScenario) | **POST** /active/{name} | Deploy a scenario
*AdvantEdgeSandboxControllerRestApi.ActiveScenarioApi* | [**getActiveNodeServiceMaps**](docs/ActiveScenarioApi.md#getActiveNodeServiceMaps) | **GET** /active/serviceMaps | Get deployed scenario's port mapping
*AdvantEdgeSandboxControllerRestApi.ActiveScenarioApi* | [**getActiveScenario**](docs/ActiveScenarioApi.md#getActiveScenario) | **GET** /active | Get the deployed scenario
*AdvantEdgeSandboxControllerRestApi.ActiveScenarioApi* | [**terminateScenario**](docs/ActiveScenarioApi.md#terminateScenario) | **DELETE** /active | Terminate the deployed scenario
*AdvantEdgeSandboxControllerRestApi.EventReplayApi* | [**createReplayFile**](docs/EventReplayApi.md#createReplayFile) | **POST** /replay/{name} | Add a replay file
*AdvantEdgeSandboxControllerRestApi.EventReplayApi* | [**createReplayFileFromScenarioExec**](docs/EventReplayApi.md#createReplayFileFromScenarioExec) | **POST** /replay/{name}/generate | Generate a replay file from Active Scenario events
*AdvantEdgeSandboxControllerRestApi.EventReplayApi* | [**deleteReplayFile**](docs/EventReplayApi.md#deleteReplayFile) | **DELETE** /replay/{name} | Delete a replay file
*AdvantEdgeSandboxControllerRestApi.EventReplayApi* | [**deleteReplayFileList**](docs/EventReplayApi.md#deleteReplayFileList) | **DELETE** /replay | Delete all replay files
*AdvantEdgeSandboxControllerRestApi.EventReplayApi* | [**getReplayFile**](docs/EventReplayApi.md#getReplayFile) | **GET** /replay/{name} | Get a specific replay file
*AdvantEdgeSandboxControllerRestApi.EventReplayApi* | [**getReplayFileList**](docs/EventReplayApi.md#getReplayFileList) | **GET** /replay | Get all replay file names
*AdvantEdgeSandboxControllerRestApi.EventReplayApi* | [**getReplayStatus**](docs/EventReplayApi.md#getReplayStatus) | **GET** /replaystatus | Get status of replay manager
*AdvantEdgeSandboxControllerRestApi.EventReplayApi* | [**loopReplay**](docs/EventReplayApi.md#loopReplay) | **POST** /replay/{name}/loop | Loop-Execute a replay file present in the platform store
*AdvantEdgeSandboxControllerRestApi.EventReplayApi* | [**playReplayFile**](docs/EventReplayApi.md#playReplayFile) | **POST** /replay/{name}/play | Execute a replay file present in the platform store
*AdvantEdgeSandboxControllerRestApi.EventReplayApi* | [**stopReplayFile**](docs/EventReplayApi.md#stopReplayFile) | **POST** /replay/{name}/stop | Stop execution of a replay file
*AdvantEdgeSandboxControllerRestApi.EventsApi* | [**sendEvent**](docs/EventsApi.md#sendEvent) | **POST** /events/{type} | Send events to the deployed scenario


## Documentation for Models

 - [AdvantEdgeSandboxControllerRestApi.ActivationInfo](docs/ActivationInfo.md)
 - [AdvantEdgeSandboxControllerRestApi.CellularDomainConfig](docs/CellularDomainConfig.md)
 - [AdvantEdgeSandboxControllerRestApi.CellularPoaConfig](docs/CellularPoaConfig.md)
 - [AdvantEdgeSandboxControllerRestApi.CpuConfig](docs/CpuConfig.md)
 - [AdvantEdgeSandboxControllerRestApi.Deployment](docs/Deployment.md)
 - [AdvantEdgeSandboxControllerRestApi.Domain](docs/Domain.md)
 - [AdvantEdgeSandboxControllerRestApi.EgressService](docs/EgressService.md)
 - [AdvantEdgeSandboxControllerRestApi.Event](docs/Event.md)
 - [AdvantEdgeSandboxControllerRestApi.EventMobility](docs/EventMobility.md)
 - [AdvantEdgeSandboxControllerRestApi.EventNetworkCharacteristicsUpdate](docs/EventNetworkCharacteristicsUpdate.md)
 - [AdvantEdgeSandboxControllerRestApi.EventPoasInRange](docs/EventPoasInRange.md)
 - [AdvantEdgeSandboxControllerRestApi.EventScenarioUpdate](docs/EventScenarioUpdate.md)
 - [AdvantEdgeSandboxControllerRestApi.ExternalConfig](docs/ExternalConfig.md)
 - [AdvantEdgeSandboxControllerRestApi.GeoData](docs/GeoData.md)
 - [AdvantEdgeSandboxControllerRestApi.GpuConfig](docs/GpuConfig.md)
 - [AdvantEdgeSandboxControllerRestApi.IngressService](docs/IngressService.md)
 - [AdvantEdgeSandboxControllerRestApi.LineString](docs/LineString.md)
 - [AdvantEdgeSandboxControllerRestApi.MemoryConfig](docs/MemoryConfig.md)
 - [AdvantEdgeSandboxControllerRestApi.NetworkCharacteristics](docs/NetworkCharacteristics.md)
 - [AdvantEdgeSandboxControllerRestApi.NetworkLocation](docs/NetworkLocation.md)
 - [AdvantEdgeSandboxControllerRestApi.NodeDataUnion](docs/NodeDataUnion.md)
 - [AdvantEdgeSandboxControllerRestApi.NodeServiceMaps](docs/NodeServiceMaps.md)
 - [AdvantEdgeSandboxControllerRestApi.PhysicalLocation](docs/PhysicalLocation.md)
 - [AdvantEdgeSandboxControllerRestApi.Poa4GConfig](docs/Poa4GConfig.md)
 - [AdvantEdgeSandboxControllerRestApi.Poa5GConfig](docs/Poa5GConfig.md)
 - [AdvantEdgeSandboxControllerRestApi.PoaWifiConfig](docs/PoaWifiConfig.md)
 - [AdvantEdgeSandboxControllerRestApi.Point](docs/Point.md)
 - [AdvantEdgeSandboxControllerRestApi.Process](docs/Process.md)
 - [AdvantEdgeSandboxControllerRestApi.Replay](docs/Replay.md)
 - [AdvantEdgeSandboxControllerRestApi.ReplayEvent](docs/ReplayEvent.md)
 - [AdvantEdgeSandboxControllerRestApi.ReplayFileList](docs/ReplayFileList.md)
 - [AdvantEdgeSandboxControllerRestApi.ReplayInfo](docs/ReplayInfo.md)
 - [AdvantEdgeSandboxControllerRestApi.ReplayStatus](docs/ReplayStatus.md)
 - [AdvantEdgeSandboxControllerRestApi.Scenario](docs/Scenario.md)
 - [AdvantEdgeSandboxControllerRestApi.ScenarioConfig](docs/ScenarioConfig.md)
 - [AdvantEdgeSandboxControllerRestApi.ScenarioNode](docs/ScenarioNode.md)
 - [AdvantEdgeSandboxControllerRestApi.ServiceConfig](docs/ServiceConfig.md)
 - [AdvantEdgeSandboxControllerRestApi.ServicePort](docs/ServicePort.md)
 - [AdvantEdgeSandboxControllerRestApi.Zone](docs/Zone.md)


## Documentation for Authorization

 All endpoints do not require authorization.

